/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class DefaultEocMappingGetService
extends AbstractApiService {
    public DefaultEocMappingGetService() {
        this.jsonSchemaFileName = "default_eoc_mapping_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        ObjectNode tAddMappingNode;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tProdName = tRequestJsonNode.get("prod_name").asText();
        String tUid = tRequestJsonNode.get("uid").asText();
        ObjectNode tEocNode = EocInfoServiceUtil.getEocInfoByTenantId(tTenantId);
        JsonNode tIntgInfoNode = IntgInfoServiceUtil.getIntgInfo(null, tTenantId, tProdName, tUid);
        ArrayNode tMappingInfoAryNode = this.mapper.createArrayNode();
        ObjectNode tEocDataNode = (ObjectNode)tEocNode.get("data");
        ArrayNode tEocCompanyAryNode = (ArrayNode)tEocDataNode.get("companies");
        ArrayNode tEocFactoriesAryNode = (ArrayNode)tEocDataNode.get("factories");
        ArrayNode tEocRegionAryNode = (ArrayNode)tEocDataNode.get("areas");
        for (JsonNode tEocCompanyObject : tEocCompanyAryNode) {
            ArrayNode tIntgCompanyAryNode = (ArrayNode)tIntgInfoNode.get("org_type_company");
            for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
                tAddMappingNode = this.mapper.createObjectNode();
                if (!tEocCompanyObject.get("id").asText().equals(tIntgCompanyObject.get("company_no").asText())) continue;
                tAddMappingNode.put("eoc_id", tEocCompanyObject.get("id").asText());
                tAddMappingNode.put("intg_id", tIntgCompanyObject.get("company_no").asText());
                tAddMappingNode.put("level", "company_id");
                tAddMappingNode.put("prod_name", tProdName);
                tAddMappingNode.put("uid", tUid);
                tMappingInfoAryNode.add((JsonNode)tAddMappingNode);
                for (JsonNode tEocFactoryObject : tEocFactoriesAryNode) {
                    if (!tEocFactoryObject.get("companyId").asText().equals(tEocCompanyObject.get("id").asText())) continue;
                    ObjectNode tAddMappingWithParentNode = this.mapper.createObjectNode();
                    if (tIntgCompanyObject.get("org_type_site") == null) continue;
                    ArrayNode tIntgSiteAryNodeUnderCompany = (ArrayNode)tIntgCompanyObject.get("org_type_site");
                    for (JsonNode tIntgSiteObject : tIntgSiteAryNodeUnderCompany) {
                        if (!tIntgSiteObject.get("site_no").asText().equals(tEocFactoryObject.get("id").asText())) continue;
                        tAddMappingWithParentNode.put("eoc_id", tEocFactoryObject.get("id").asText());
                        tAddMappingWithParentNode.put("intg_id", tIntgSiteObject.get("site_no").asText());
                        tAddMappingWithParentNode.put("level", "site_id");
                        tAddMappingWithParentNode.put("parent_level", "company_id");
                        tAddMappingWithParentNode.put("parent_eoc_id", tEocCompanyObject.get("id").asText());
                        tAddMappingWithParentNode.put("prod_name", tProdName);
                        tAddMappingWithParentNode.put("uid", tUid);
                        tMappingInfoAryNode.add((JsonNode)tAddMappingWithParentNode);
                    }
                }
            }
        }
        for (JsonNode tEocRegionObject : tEocRegionAryNode) {
            ArrayNode tIntgRegionAryNode = (ArrayNode)tIntgInfoNode.get("org_type_region");
            for (JsonNode tIntgRegionObject : tIntgRegionAryNode) {
                tAddMappingNode = this.mapper.createObjectNode();
                if (!tEocRegionObject.get("id").asText().equals(tIntgRegionObject.get("region_no").asText()) || !tIntgRegionObject.get("region_type").asText().equals(tEocRegionObject.get("type").asText())) continue;
                tAddMappingNode.put("eoc_id", tEocRegionObject.get("id").asText());
                tAddMappingNode.put("region_type", tIntgRegionObject.get("region_type").asText());
                tAddMappingNode.put("intg_id", tIntgRegionObject.get("region_no").asText());
                tAddMappingNode.put("level", "region_id");
                tAddMappingNode.put("prod_name", tProdName);
                tAddMappingNode.put("uid", tUid);
                tMappingInfoAryNode.add((JsonNode)tAddMappingNode);
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("mapping_info", (JsonNode)tMappingInfoAryNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

