/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EOCIntgMapUpdateService
extends AbstractApiService {
    @Autowired
    private ProductDao productDao;
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private PrdDatakeyMappingDao prdDatakeyMappingDao;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;

    public EOCIntgMapUpdateService() {
        this.jsonSchemaFileName = "eoc_intg_map_update_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        this.updateEocOmMapping(tRequestJsonNode);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private void updateEocOmMapping(JsonNode pNode) {
        ArrayList<EocIntgMapping> tList = new ArrayList<EocIntgMapping>();
        ArrayNode tMappingInfoAryNode = (ArrayNode)pNode.get("mapping_info");
        String tTenantId = pNode.get("tenant_id").asText();
        String tAction = pNode.get("action").asText();
        String tEocSetting = null;
        String tEocSettingRegion = null;
        if (pNode.get("eoc_setting") != null && pNode.get("eoc_setting").asText().length() != 0) {
            tEocSetting = pNode.get("eoc_setting").asText();
        }
        if (pNode.get("eoc_setting_region") != null && pNode.get("eoc_setting_region").asText().length() != 0) {
            tEocSettingRegion = pNode.get("eoc_setting_region").asText();
        }
        if (tAction.equals("delete")) {
            String tLevel = pNode.get("level").asText();
            String tUid = pNode.get("uid").asText();
            this.eocIntgMappingDao.clearListWithLevel(tTenantId, tUid, tLevel);
            HashMap<String, String> tProductCondition = new HashMap<String, String>();
            tProductCondition.put("tenant", tTenantId);
            tProductCondition.put("uid", tUid);
            List<Product> tProducts = this.productDao.fetch(tProductCondition);
            HashMap<String, String> tEocIntgCondition = new HashMap<String, String>();
            tEocIntgCondition.put("product_uid", tUid);
            tEocIntgCondition.put("tenant_id", tTenantId);
            List<EocIntgMapping> tEocIntgMappings = this.eocIntgMappingDao.fetch(tEocIntgCondition);
            if (tProducts != null && tProducts.size() != 0 && tEocIntgMappings.size() == 0) {
                tProducts.get(0).setTenantId("");
                this.productDao.save(tProducts.get(0));
            }
        } else {
            if (tMappingInfoAryNode.isArray()) {
                for (JsonNode tNode : tMappingInfoAryNode) {
                    if (tNode.get("parent_eoc_id") != null && tNode.get("parent_eoc_id").asText().length() != 0) continue;
                    EocIntgMapping tMapping = new EocIntgMapping();
                    if (tNode.get("eoc_id") == null) continue;
                    tMapping.setEocId(tNode.get("eoc_id").asText());
                    tMapping.setIntgId(tNode.get("intg_id").asText());
                    tMapping.setEocLevel(tNode.get("level").asText());
                    tMapping.setProducName(tNode.get("prod_name").asText());
                    tMapping.setProductUid(tNode.get("uid").asText());
                    tMapping.setTenantId(tTenantId);
                    if (tNode.get("region_type") != null) {
                        tMapping.setRegionType(tNode.get("region_type").asText());
                    }
                    HashMap<String, String> tPrdDatakeyMappingCondition = new HashMap<String, String>();
                    tPrdDatakeyMappingCondition.put("prod_name", tNode.get("prod_name").asText());
                    tPrdDatakeyMappingCondition.put("eoc_level", tNode.get("level").asText());
                    List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
                    if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
                        tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
                    }
                    tMapping.setBuildTime(Calendar.getInstance());
                    tList.add(tMapping);
                }
            }
            if (pNode.get("eoc_setting_region") != null) {
                this.eocIntgMappingDao.clearListWithLevel(tTenantId, ((EocIntgMapping)tList.get(0)).getProductUid(), "Region");
            } else {
                this.eocIntgMappingDao.clearList(tTenantId, ((EocIntgMapping)tList.get(0)).getProductUid());
            }
            this.eocIntgMappingDao.updateList(tList);
            tList.clear();
            for (JsonNode tNode : tMappingInfoAryNode) {
                if (tNode.get("parent_eoc_id") == null || tNode.get("parent_eoc_id").asText().length() == 0 || tNode.get("parent_level") == null || tNode.get("parent_level").asText().length() == 0) continue;
                HashMap<String, String> tEocIntgMappingCondition = new HashMap<String, String>();
                tEocIntgMappingCondition.put("eoc_id", tNode.get("parent_eoc_id").asText());
                tEocIntgMappingCondition.put("eoc_level", tNode.get("parent_level").asText());
                tEocIntgMappingCondition.put("prod_name", tNode.get("prod_name").asText());
                tEocIntgMappingCondition.put("tenant_id", tTenantId);
                List<EocIntgMapping> tEocIntgMappings = this.eocIntgMappingDao.fetch(tEocIntgMappingCondition);
                EocIntgMapping tMapping = new EocIntgMapping();
                tMapping.setEocId(tNode.get("eoc_id").asText());
                tMapping.setIntgId(tNode.get("intg_id").asText());
                tMapping.setEocLevel(tNode.get("level").asText());
                tMapping.setProducName(tNode.get("prod_name").asText());
                tMapping.setProductUid(tNode.get("uid").asText());
                tMapping.setTenantId(tTenantId);
                if (tEocIntgMappings != null && !tEocIntgMappings.isEmpty()) {
                    tMapping.setEocIntgMapping(tEocIntgMappings.get(0));
                }
                HashMap<String, String> tPrdDatakeyMappingCondition = new HashMap<String, String>();
                tPrdDatakeyMappingCondition.put("prod_name", tNode.get("prod_name").asText());
                tPrdDatakeyMappingCondition.put("eoc_level", tNode.get("level").asText());
                List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
                if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
                    tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
                }
                tMapping.setBuildTime(Calendar.getInstance());
                tList.add(tMapping);
            }
            this.eocIntgMappingDao.updateList(tList);
            HashMap<String, String> tProductCondition = new HashMap<String, String>();
            tProductCondition.put("uid", tMappingInfoAryNode.get(0).get("uid").asText());
            List<Product> tProducts = this.productDao.fetch(tProductCondition);
            boolean tProductWithSameTenantIdExist = false;
            boolean tProductWithNoTenantIdExist = false;
            for (Product tProduct : tProducts) {
                if (!tTenantId.equals(tProduct.getTenantId())) continue;
                if (tEocSetting != null) {
                    tProduct.setEocSetting(tEocSetting);
                }
                if (tEocSettingRegion != null) {
                    tProduct.setEocSettingRegion(tEocSettingRegion);
                }
                tProduct.setLastUpdateTime(Calendar.getInstance());
                this.productDao.save(tProduct);
                tProductWithSameTenantIdExist = true;
            }
            if (!tProductWithSameTenantIdExist) {
                List<EaiTenantMapping> eaiTenantMappings;
                HashMap<String, String> tCondition;
                for (Product tProduct : tProducts) {
                    if (tProduct.getTenantId() != null && tProduct.getTenantId().length() != 0) continue;
                    tCondition = new HashMap<String, String>();
                    tCondition.put("tenant", tTenantId);
                    eaiTenantMappings = this.eaiTenantMappingDao.fetch(tCondition);
                    if (eaiTenantMappings == null || eaiTenantMappings.size() == 0 || !tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) continue;
                    if (tEocSetting != null) {
                        tProduct.setEocSetting(tEocSetting);
                    }
                    if (tEocSettingRegion != null) {
                        tProduct.setEocSettingRegion(tEocSettingRegion);
                    }
                    tProduct.setTenantId(tTenantId);
                    tProduct.setLastUpdateTime(Calendar.getInstance());
                    this.productDao.save(tProduct);
                    tProductWithNoTenantIdExist = true;
                    break;
                }
                if (!tProductWithNoTenantIdExist) {
                    for (Product tProduct : tProducts) {
                        tCondition = new HashMap();
                        tCondition.put("tenant", tTenantId);
                        eaiTenantMappings = this.eaiTenantMappingDao.fetch(tCondition);
                        if (eaiTenantMappings == null || eaiTenantMappings.size() == 0 || !tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) continue;
                        List<com.digiwin.metadatacache.model.Service> tServices = this.serviceDao.getByPrdId(tProduct.getId());
                        if (tEocSetting != null) {
                            tProduct.setEocSetting(tEocSetting);
                        }
                        if (tEocSettingRegion != null) {
                            tProduct.setEocSettingRegion(tEocSettingRegion);
                        }
                        tProduct.setBuildTime(Calendar.getInstance());
                        tProduct.setTenantId(tTenantId);
                        tProduct.setId(null);
                        Product tReturnedProduct = this.productDao.save(tProduct);
                        for (com.digiwin.metadatacache.model.Service service : tServices) {
                            service.setProduct(tReturnedProduct);
                            service.setId(null);
                            this.serviceDao.save(service);
                        }
                    }
                }
            }
        }
    }
}

