/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class EocInfoV2GetService
extends AbstractApiService {
    public EocInfoV2GetService() {
        this.jsonSchemaFileName = "eoc_info_v2_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        Object tToken = DWServiceContext.getContext().getRequestHeader().get("token");
        ObjectNode tEocInfoNode = null != tToken ? EocInfoServiceUtil.getEocInfoV2ByUserToken(tToken.toString()) : EocInfoServiceUtil.getEocInfoV2ByTenantId(tTenantId);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tEocInfoNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    @Override
    protected ObjectNode createResponseJsonNode(String pCode, String pDescription, JsonNode pEocInfoNode) {
        ObjectNode tResponseJsonNode = this.mapper.createObjectNode();
        ObjectNode tExecutionNode = this.mapper.createObjectNode();
        tResponseJsonNode.set("execution", (JsonNode)tExecutionNode);
        tExecutionNode.put("code", pCode);
        if (!StringUtil.isEmptyOrSpace(pDescription)) {
            tExecutionNode.put("description", pDescription);
        }
        if (pEocInfoNode != null) {
            ObjectNode eocInfoResult = this.mapper.createObjectNode();
            ObjectNode dataResult = this.mapper.createObjectNode();
            ArrayNode operations = this.mapper.createArrayNode();
            JsonNode data = pEocInfoNode.get("data");
            if (data != null) {
                JsonNode listNode = data.get("list");
                if (listNode instanceof ArrayNode) {
                    ArrayNode list = (ArrayNode)listNode;
                    list.forEach(x -> {
                        if (x.hasNonNull("id") && x.hasNonNull("name")) {
                            operations.add((JsonNode)this.mapper.createObjectNode().put("id", x.get("id").asText()).put("name", x.get("name").asText()));
                        }
                    });
                }
                dataResult.set("operations", (JsonNode)operations);
                eocInfoResult.put("code", pEocInfoNode.get("code").asText());
                eocInfoResult.put("message", pEocInfoNode.get("message").asText());
                eocInfoResult.set("data", (JsonNode)dataResult);
            }
            tResponseJsonNode.set("eoc_info", (JsonNode)eocInfoResult);
        }
        return tResponseJsonNode;
    }
}

