/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.annotate.AppTokenVerify;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.AddProdNotExistException;
import com.digiwin.metadatacache.exception.AddProdNotFoundException;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@AppTokenVerify
public class ProductInfoAddService
extends AbstractApiService {
    @Autowired
    private ProductDao productDao;
    @Autowired
    private ServiceDao serviceDao;

    public ProductInfoAddService() {
        this.jsonSchemaFileName = "tenant_prd_info_add_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        ArrayNode tProductAryNode;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String eaiUId = null;
        String tGatewayId = null;
        if (tRequestJsonNode.has("eai_uid")) {
            eaiUId = tRequestJsonNode.get("eai_uid").asText();
        }
        if (tRequestJsonNode.get("gateway_id") != null && tRequestJsonNode.get("gateway_id").asText().length() != 0) {
            tGatewayId = tRequestJsonNode.get("gateway_id").asText();
        }
        if ((tProductAryNode = (ArrayNode)tRequestJsonNode.get("product")).size() == 0) {
            throw new AddProdNotExistException(this.getClass());
        }
        this.addProductAndService(tProductAryNode, eaiUId, tGatewayId);
        return this.returnByCode(validatorResult.getState().getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProductAndService(ArrayNode tProductAryNode, String eaiUId, String tGatewayId) throws BaseException, InterruptedException {
        ArrayList<com.digiwin.metadatacache.model.Service> addServiceList = new ArrayList<com.digiwin.metadatacache.model.Service>();
        for (JsonNode tProductNode : tProductAryNode) {
            String name = tProductNode.get("name").asText();
            String uid = tProductNode.get("uid").asText();
            String pKey = name + ":" + uid + ":" + eaiUId;
            try {
                String prKey;
                Product product;
                if (!this.cacheService.lock(pKey + "cache")) {
                    return;
                }
                HashMap<String, String> tProductCondition = new HashMap<String, String>();
                tProductCondition.put("eai_uid", eaiUId);
                tProductCondition.put("uid", uid);
                tProductCondition.put("name", name);
                List<Product> productList = this.productDao.fetch(tProductCondition);
                if (productList.size() > 1) {
                    throw new AddProdNotFoundException("UID(" + uid + "),name(" + name + ")", this.getClass());
                }
                if (CollectionUtils.isEmpty(productList)) {
                    product = new Product();
                    product.setName(name);
                    product.setUid(uid);
                    product.setEaiUid(eaiUId);
                    product.setVersion(tProductNode.get("version").asText());
                    product.setIp(tProductNode.get("ip").asText());
                    product.setApid(tProductNode.get("id").asText());
                    product.setGatewayId(tGatewayId);
                    if (!StringUtil.isEmptyOrSpace(tProductNode.get("setting_eoc_flag"))) {
                        product.setSettingEocFlag(tProductNode.get("setting_eoc_flag").asInt());
                    }
                    if (!StringUtil.isEmptyOrSpace(tProductNode.get("appid"))) {
                        product.setAppId(tProductNode.get("appid").asText());
                    }
                    if (tProductNode.get("url") != null) {
                        product.setUrl(tProductNode.get("url").asText());
                    }
                    product.setBuildTime(Calendar.getInstance());
                    product.setLastUpdateTime(Calendar.getInstance());
                    if (eaiUId == null) {
                        product.setProductType(ApiTypeEnum.agile.toString());
                    } else {
                        product.setProductType(ApiTypeEnum.standard.toString());
                    }
                    product = this.productDao.save(product);
                } else {
                    product = productList.get(0);
                }
                List<com.digiwin.metadatacache.model.Service> tCurrentServiceList = this.serviceDao.getByPrdId(product.getId());
                ArrayNode tSrvInfoAryNode = (ArrayNode)tProductNode.get("services");
                for (JsonNode tSrvNode : tSrvInfoAryNode) {
                    String serviceName = tSrvNode.get("name").asText();
                    String version = null;
                    if (tSrvNode.has("version")) {
                        version = tSrvNode.get("version").asText();
                    }
                    boolean isExist = false;
                    for (com.digiwin.metadatacache.model.Service service : tCurrentServiceList) {
                        if (!serviceName.equals(service.getName())) continue;
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    com.digiwin.metadatacache.model.Service tService = new com.digiwin.metadatacache.model.Service();
                    tService.setBuildTime(Calendar.getInstance());
                    tService.setProduct(product);
                    tService.setName(serviceName);
                    tService.setVersion(version);
                    addServiceList.add(tService);
                }
                if (addServiceList.size() <= 0) continue;
                this.serviceDao.saveServices(addServiceList);
                if (StringUtils.isNotBlank((CharSequence)eaiUId)) {
                    prKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + product.getTenantId();
                    Map tProductServiceMapFromCache = (Map)this.cacheService.get(prKey);
                    this.addServiceFromProductInCache(tProductServiceMapFromCache, addServiceList, product, prKey);
                    continue;
                }
                for (com.digiwin.metadatacache.model.Service service : addServiceList) {
                    prKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + "agile" + ":" + service.getName();
                    Map tProductMap = (Map)this.cacheService.get(prKey);
                    this.addProductInCache(tProductMap, product, null == service.getVersion() ? "" : service.getVersion(), prKey);
                }
            }
            finally {
                this.cacheService.unLock(pKey + "cache");
            }
        }
    }

    private Map<String, Object> returnByCode(String code) {
        StateCode tStateCode = this.getStateCode(code);
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private void addServiceFromProductInCache(Map<String, List<String>> tProductServiceMapFromCache, List<com.digiwin.metadatacache.model.Service> services, Product pProduct, String tKey) {
        String tProductKey = pProduct.getName() + ":" + pProduct.getUid() + ":" + pProduct.getEaiUid();
        if (tProductServiceMapFromCache != null && tProductServiceMapFromCache.get(tProductKey) != null) {
            this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u66f4\u65b0\u5feb\u53d6(\u7522\u54c1\u4e2d\u7684\u670d\u52d9)\uff1atenant = " + pProduct.getTenantId() + ", product = " + tProductKey + ", service = " + services));
            tProductServiceMapFromCache.get(tProductKey).addAll(services.stream().map(x -> x.getName() + "/" + (null == x.getVersion() ? "" : x.getVersion())).collect(Collectors.toList()));
            this.cacheService.setSync(tKey, tProductServiceMapFromCache);
        }
    }

    private void addProductInCache(Map<String, String> tProductMap, Product pProduct, String serviceVersion, String tKey) {
        String tProductKey = pProduct.getName() + ":" + pProduct.getUid();
        if (null != tProductMap) {
            this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u66f4\u65b0\u5feb\u53d6(\u7522\u54c1\u4e2d\u7684\u670d\u52d9)\uff1apProduct = " + pProduct.getTenantId() + ", product = " + tProductKey + ", service = " + tKey));
            String tProductFullInfo = pProduct.getName() + "/" + pProduct.getUid() + "/" + pProduct.getEaiUid() + "/" + pProduct.getVersion() + "/" + pProduct.getIp() + "/" + pProduct.getApid() + "/" + pProduct.getGatewayId() + ":::" + serviceVersion;
            tProductMap.put(tProductKey, tProductFullInfo);
            this.cacheService.setSyncTimeOut(tKey, tProductMap, MdcApplicationParameter._TIME_OUT + (long)((int)(Math.random() * (double)MdcApplicationParameter._TIME_RANDOM)));
        }
    }
}

