/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.metadatacache.apiservice.ApiBaseInfoGetService;
import com.digiwin.metadatacache.apiservice.TenantProductOperationListGetService;
import com.digiwin.metadatacache.apiservice.request.SeviceBaseInfoGetRequest;
import com.digiwin.metadatacache.apiservice.response.SeviceBaseInfoGetResponse;
import com.digiwin.metadatacache.bo.ApiRelationCacheVal;
import com.digiwin.metadatacache.bo.KgServiceProductConfigDto;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.enums.ErrorCodeEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.exception.MultipleProdException;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.DispatchService;
import com.digiwin.metadatacache.services.LocalCacheService;
import com.digiwin.metadatacache.services.MdcKgService;
import com.digiwin.metadatacache.services.MdcProductService;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.util.JsonUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceBaseInfoGetService
extends ApiBaseInfoGetService {
    @Autowired
    private MdcProductService productService;
    @Autowired
    private TenantProductOperationListGetService tenantProductOperationListGetService;
    @Autowired
    private DispatchService dispatchService;
    @Autowired
    private LocalCacheService localCacheService;
    @Autowired
    private MdcKgService kgService;

    public ServiceBaseInfoGetService() {
        this.jsonSchemaFileName = "service_base_info_get.json";
    }

    @Override
    public Map<String, Object> execute(String pRequestMsg) throws Exception {
        StateCode tStateCode;
        StringBuilder tDescription = new StringBuilder();
        if (DWServiceContext.getContext().getRequestHeader().get("locale") != null) {
            this.locale = DWServiceContext.getContext().getRequestHeader().get("locale").toString();
        }
        try {
            ValidatorResult tValidatorResult = this.validate(pRequestMsg);
            return this.processData(tValidatorResult);
        }
        catch (DWHttpFailedException e) {
            String exceptionEntity = (String)e.getEntity(String.class);
            this.log.error((Object)("exceptionEntity = " + exceptionEntity + ";requestMsg = " + pRequestMsg), (Throwable)e);
            throw new Exception(exceptionEntity);
        }
        catch (BaseException e) {
            this.log.error((Object)(e.getMessage() + ";requestMsg = " + pRequestMsg), (Throwable)e);
            tStateCode = this.getStateCode(e.getStateEnum().getCode());
            tDescription.append(this.getDescriptionByLocale(tStateCode, this.locale));
            if (!StringUtil.isEmptyOrSpace(e.getMessage())) {
                tDescription.append("\uff1a").append(e.getMessage());
            }
        }
        catch (Exception e) {
            this.log.error((Object)(e.getMessage() + ";requestMsg = " + pRequestMsg), (Throwable)e);
            tStateCode = this.getStateCode(ValidateStateEnum.UNEXPECTED_ERROR.getCode());
            tDescription.append(this.getDescriptionByLocale(tStateCode, this.locale));
        }
        return this.convertErrorResult(tStateCode.getCode(), tDescription.toString());
    }

    private Map<String, Object> convertErrorResult(String stateCode, String description) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        ErrorCodeEnum errorCode = ErrorCodeEnum.ERRORCODEENUM_CODE_MAP.get(stateCode);
        if (null == errorCode) {
            errorCode = ErrorCodeEnum.UNEXPECTED_ERROR;
        }
        response.put("errorCode", errorCode.getErrorCode());
        response.put("errorMessage", description);
        String chainInfo = DWServiceChainContext.getContext().getTraceElement().getTraceInfo(true);
        chainInfo = StringUtils.substringAfter((String)chainInfo, (String)"trace info: me: ");
        HashMap<String, String> chainInfoNode = new HashMap<String, String>();
        chainInfoNode.put("chainInfo", chainInfo);
        response.put("errorInstructors", chainInfoNode);
        return response;
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
        String tDescription = this.getDescriptionByLocale(SUCCESS_STATE, this.locale);
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        SeviceBaseInfoGetRequest request = JsonUtil.toJavaObj(tRequestJsonNode, SeviceBaseInfoGetRequest.class);
        SeviceBaseInfoGetResponse response = new SeviceBaseInfoGetResponse();
        String apiName = request.getApiName();
        String tenantId = request.getTenantId();
        SeviceBaseInfoGetResponse.Api apiInfo = this.getApiInfo(apiName, tenantId, request.isNeedIdempotency());
        response.setApi(apiInfo);
        String realApiName = StringUtils.isNotBlank((CharSequence)apiInfo.getParentApi()) ? apiInfo.getParentApi() : apiName;
        SeviceBaseInfoGetResponse.Product product = this.getProductInfo(request, realApiName);
        response.setProd(product);
        if (null == product || ApiTypeEnum.agile.toString().equals(product.getProductType())) {
            String prodName = null == product ? request.getServiceProd() : product.getName();
            Map<String, Object> eoc = this.createAgileEmptyEocRs(prodName, tenantId);
            response.setEoc(eoc);
            return this.createResponseMap(SUCCESS_STATE.getCode(), tDescription, response.toMap());
        }
        String version = IamVerifyServiceUtil.getCurrentTenantVersion(tenantId);
        response.setTenantVersion(version);
        Map<String, Object> eoc = "v2".equalsIgnoreCase(version) ? this.tenantProductOperationListGetService.tenantProdOperationListGetV2(tenantId, product.getName(), product.getUid(), null) : this.tenantProductOperationListGetService.processTenantProdOperationListGet(tenantId, product.getName(), product.getUid(), null);
        eoc.remove("execution");
        response.setEoc(eoc);
        if (!request.isNeedDispatch()) {
            return this.createResponseMap(SUCCESS_STATE.getCode(), tDescription, response.toMap());
        }
        if (!this.dispatchService.isCanDispatch(product.getName(), realApiName)) {
            return this.createResponseMap(SUCCESS_STATE.getCode(), tDescription, response.toMap());
        }
        List<Map<String, Object>> dispatchList = "v2".equalsIgnoreCase(version) ? this.dispatchService.getDispatchV2(tenantId, product.getName()) : this.dispatchService.getDispatch(tenantId, product.getName());
        response.setDispatch(dispatchList);
        return this.createResponseMap(SUCCESS_STATE.getCode(), tDescription, response.toMap());
    }

    private SeviceBaseInfoGetResponse.Product getProductInfo(SeviceBaseInfoGetRequest request, String realApiName) throws BaseException {
        List<Product> products = this.getProductFromCache(request, realApiName);
        if (CollectionUtils.isEmpty(products)) {
            products = this.productService.getProductFromDb(request.getTenantId(), realApiName, request.getServiceProd(), request.getServiceProdUid());
        }
        if (CollectionUtils.isEmpty(products)) {
            return null;
        }
        Product matchedProd = null;
        matchedProd = products.size() == 1 ? products.get(0) : this.matchProductByConfig(request.getTenantId(), realApiName, products);
        return new SeviceBaseInfoGetResponse.Product(matchedProd.getName(), matchedProd.getUid(), matchedProd.getProductType());
    }

    private SeviceBaseInfoGetResponse.Product getProductInfoV2(SeviceBaseInfoGetRequest request, String realApiName) throws BaseException {
        List<Product> products = this.productService.getProductFromDbNoCache(request.getTenantId(), realApiName, request.getServiceProd(), request.getServiceProdUid());
        if (CollectionUtils.isEmpty(products)) {
            return null;
        }
        Product matchedProd = null;
        matchedProd = products.size() == 1 ? products.get(0) : this.matchProductByConfig(request.getTenantId(), realApiName, products);
        return new SeviceBaseInfoGetResponse.Product(matchedProd.getName(), matchedProd.getUid(), matchedProd.getProductType());
    }

    private Product matchProductByConfig(String tenantId, String realApi, List<Product> products) throws BaseException {
        KgServiceProductConfigDto configDto = this.kgService.getServiceProductConfig(tenantId, realApi);
        if (null == configDto || null == configDto.getTenantServiceConfig() && CollectionUtils.isEmpty(configDto.getSystemServiceConfig())) {
            throw new MultipleProdException(this.getClass());
        }
        Product matchedProd = null;
        if (configDto.getTenantServiceConfig() != null) {
            matchedProd = products.stream().filter(prod -> StringUtils.equals((CharSequence)prod.getName(), (CharSequence)configDto.getTenantServiceConfig().getProductName())).findFirst().orElse(null);
        }
        if (CollectionUtils.isEmpty(configDto.getSystemServiceConfig())) {
            return matchedProd;
        }
        return products.stream().filter(prod -> configDto.getSystemServiceConfig().contains(prod.getName())).findFirst().orElse(null);
    }

    private SeviceBaseInfoGetResponse.Api getApiInfo(String apiName, String tenantId, boolean needIdempotency) {
        ApiRelationCacheVal relationCacheVal = (ApiRelationCacheVal)this.localCacheService.getFromL2Cache(CacheMapTypeEnum.api_relation_idempotency_cachemap, apiName, tenantId);
        SeviceBaseInfoGetResponse.Api api = new SeviceBaseInfoGetResponse.Api();
        api.setName(apiName);
        if (relationCacheVal != null) {
            api.setParentApi(relationCacheVal.getParent());
            if (!needIdempotency) {
                return api;
            }
            if (relationCacheVal.getIdempotency() != null) {
                api.setIdempotency(relationCacheVal.getIdempotency());
                return api;
            }
        } else {
            String parentName = this.getParentName(apiName, tenantId);
            api.setParentApi(parentName);
        }
        if (needIdempotency) {
            api.setIdempotency(this.getIdempotency(apiName, tenantId, api.getParentApi()));
        }
        this.saveApiRelationCache(apiName, tenantId, new ApiRelationCacheVal(api.getParentApi(), api.getIdempotency()));
        return api;
    }

    private SeviceBaseInfoGetResponse.Api getApiInfoV2(String apiName, String tenantId, boolean needIdempotency) {
        SeviceBaseInfoGetResponse.Api api = new SeviceBaseInfoGetResponse.Api();
        api.setName(apiName);
        String parentName = this.getParentName(apiName, tenantId);
        api.setParentApi(parentName);
        if (needIdempotency) {
            api.setIdempotency(this.getIdempotency(apiName, tenantId, api.getParentApi()));
        }
        return api;
    }

    private boolean getIdempotency(String apiName, String tenantId, String parentApi) {
        String realApiName = null == parentApi ? apiName : parentApi;
        ApiVersion version = this.getBaseInfo(realApiName, tenantId);
        boolean idempotency = null == version ? false : version.isIdempotency();
        return idempotency;
    }

    private void saveApiRelationCache(String apiName, String tenantId, ApiRelationCacheVal val) {
        this.localCacheService.putToL2Cache(CacheMapTypeEnum.api_relation_idempotency_cachemap, apiName, tenantId, val);
    }

    private List<Product> getProductFromCache(SeviceBaseInfoGetRequest request, String realApiName) {
        String tenantId = request.getTenantId();
        String tStandardKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + tenantId;
        Map standardCache = (Map)this.cacheService.get(tStandardKey);
        List<Product> products = this.productService.getStandardProductCache(tenantId, standardCache, realApiName);
        Predicate<Product> filter = this.getProductFilter(request);
        if (CollectionUtils.isNotEmpty(products)) {
            this.log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + tStandardKey));
            products = products.stream().filter(filter).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(products) && CollectionUtils.isNotEmpty(products = this.productService.getAgileProductCache(tenantId, realApiName))) {
            products = products.stream().filter(filter).collect(Collectors.toList());
        }
        return products;
    }

    private Predicate<Product> getProductFilter(SeviceBaseInfoGetRequest request) {
        return product -> {
            if (StringUtils.isBlank((CharSequence)request.getServiceProd()) && StringUtils.isBlank((CharSequence)request.getServiceProdUid())) {
                return true;
            }
            boolean nameMatch = StringUtils.isBlank((CharSequence)request.getServiceProd()) || product.getName().equals(request.getServiceProd());
            boolean uidMatch = StringUtils.isBlank((CharSequence)request.getServiceProdUid()) || product.getUid().equals(request.getServiceProdUid());
            return nameMatch && uidMatch;
        };
    }

    private Map<String, Object> createAgileEmptyEocRs(String prod, String tenantId) {
        HashMap<String, Object> tResponseJsonNode = new HashMap<String, Object>();
        tResponseJsonNode.put("org_type_enterprise", new HashMap());
        tResponseJsonNode.put("org_type_company", new ArrayList());
        tResponseJsonNode.put("org_type_region", new ArrayList());
        tResponseJsonNode.put("tenant_id", tenantId);
        tResponseJsonNode.put("prod_name", prod);
        return tResponseJsonNode;
    }
}

