/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantOrganizationTransGetService
extends AbstractApiService {
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    public TenantOrganizationTransGetService() {
        this.jsonSchemaFileName = "tenant_org_trans_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        ObjectNode tObject;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tProdName = tRequestJsonNode.get("prod_name").asText();
        String tTarget = tRequestJsonNode.get("target").asText();
        ArrayNode tSourceAryNode = (ArrayNode)tRequestJsonNode.get("source");
        HashMap<String, String> pEocIntgMapCondition = new HashMap<String, String>();
        pEocIntgMapCondition.put("tenant_id", tTenantId);
        pEocIntgMapCondition.put("prod_name", tProdName);
        List<EocIntgMapping> eocIntgMappings = this.eocIntgMappingDao.fetch(pEocIntgMapCondition);
        Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tEocIntgMappingsMap = this.groupEocMappingByTenantAndProdNameAndUid(eocIntgMappings, tTenantId);
        ObjectNode tDataNode = this.mapper.createObjectNode();
        ArrayNode tResultAryNode = this.mapper.createArrayNode();
        tDataNode.set("result", (JsonNode)tResultAryNode);
        tDataNode.put("tenant_id", tTenantId);
        if (tTarget.equals("eoc")) {
            for (JsonNode tJsonNode : tSourceAryNode) {
                tObject = this.mapper.createObjectNode();
                if (tEocIntgMappingsMap != null && tEocIntgMappingsMap.get(tTenantId) != null && tEocIntgMappingsMap.get(tTenantId).get(tProdName) != null) {
                    for (String key : tEocIntgMappingsMap.get(tTenantId).get(tProdName).keySet()) {
                        for (EocIntgMapping mapping : tEocIntgMappingsMap.get(tTenantId).get(tProdName).get(key)) {
                            tObject.put("level", tJsonNode.get("level").asText());
                            tObject.put("id", tJsonNode.get("id").asText());
                            if (mapping.getEocLevel().equals(tJsonNode.get("level").asText()) && mapping.getIntgId().equals(tJsonNode.get("id").asText())) {
                                tObject.put("value", mapping.getEocId());
                                break;
                            }
                            tObject.set("value", (JsonNode)NullNode.getInstance());
                        }
                        tResultAryNode.add((JsonNode)tObject);
                    }
                    continue;
                }
                tObject.put("level", tJsonNode.get("level").asText());
                tObject.put("id", tJsonNode.get("id").asText());
                tObject.set("value", (JsonNode)NullNode.getInstance());
                tResultAryNode.add((JsonNode)tObject);
            }
        } else if (tTarget.equals("prod")) {
            for (JsonNode tJsonNode : tSourceAryNode) {
                tObject = this.mapper.createObjectNode();
                if (tEocIntgMappingsMap != null && tEocIntgMappingsMap.get(tTenantId) != null && tEocIntgMappingsMap.get(tTenantId).get(tProdName) != null) {
                    for (String key : tEocIntgMappingsMap.get(tTenantId).get(tProdName).keySet()) {
                        for (EocIntgMapping mapping : tEocIntgMappingsMap.get(tTenantId).get(tProdName).get(key)) {
                            tObject.put("level", tJsonNode.get("level").asText());
                            tObject.put("id", tJsonNode.get("id").asText());
                            if (mapping.getEocLevel().equals(tJsonNode.get("level").asText()) && mapping.getEocId().equals(tJsonNode.get("id").asText())) {
                                tObject.put("value", mapping.getIntgId());
                                break;
                            }
                            tObject.set("value", (JsonNode)NullNode.getInstance());
                        }
                        tResultAryNode.add((JsonNode)tObject);
                    }
                    continue;
                }
                tObject.put("level", tJsonNode.get("level").asText());
                tObject.put("id", tJsonNode.get("id").asText());
                tObject.set("value", (JsonNode)NullNode.getInstance());
                tResultAryNode.add((JsonNode)tObject);
            }
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

