/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantProductOperationListV2GetService
extends AbstractApiService {
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private ProductDao productDao;

    public TenantProductOperationListV2GetService() {
        this.jsonSchemaFileName = "tenant_prd_operation_list_v2_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tUid = null;
        String tId = null;
        if (tRequestJsonNode.get("uid") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("uid").asText())) {
            tUid = tRequestJsonNode.get("uid").asText();
        }
        if (tRequestJsonNode.get("id") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("id").asText())) {
            tId = tRequestJsonNode.get("id").asText();
        }
        if (tRequestJsonNode.get("prod_name") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("prod_name").asText())) {
            String tProdName = tRequestJsonNode.get("prod_name").asText();
            return this.processTenantProdOperationListGetV2(tTenantId, tProdName, tUid, tId);
        }
        boolean tNameInclude = false;
        if (tRequestJsonNode.get("name_include") != null) {
            tNameInclude = tRequestJsonNode.get("name_include").asBoolean();
        }
        return this.processTenantOperationListGetV2(tTenantId, tNameInclude);
    }

    private Map<String, Object> processTenantOperationListGetV2(String pTenantId, Boolean pNameInclude) {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("eoc_level", "cloud_mapping_id");
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetch(pCondition);
        Map<Object, Object> tEocNode = new HashMap();
        if (pNameInclude.booleanValue() && !tMappings.isEmpty()) {
            try {
                tEocNode = EocInfoServiceUtil.getEocInfoV2MapByTenantId(pTenantId);
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        HashMap tMappingsGroupByProductName = new HashMap();
        for (EocIntgMapping eocIntgMapping : tMappings) {
            if (tMappingsGroupByProductName.get(eocIntgMapping.getProducName()) == null) {
                ArrayList<EocIntgMapping> tProductNameMappingList = new ArrayList<EocIntgMapping>();
                tProductNameMappingList.add(eocIntgMapping);
                tMappingsGroupByProductName.put(eocIntgMapping.getProducName(), tProductNameMappingList);
                continue;
            }
            ((List)tMappingsGroupByProductName.get(eocIntgMapping.getProducName())).add(eocIntgMapping);
        }
        ArrayNode tProdEocMappingAryNode = this.mapper.createArrayNode();
        for (String tProductName : tMappingsGroupByProductName.keySet()) {
            JsonNode tIntgInfoNode = null;
            try {
                if (pNameInclude.booleanValue()) {
                    tIntgInfoNode = IntgInfoServiceUtil.getIntgInfo(null, pTenantId, tProductName, ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
                }
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            ObjectNode tProdEocMappingObjectNode = this.mapper.createObjectNode();
            if (pNameInclude.booleanValue()) {
                HashMap<String, String> tPrdCondition = new HashMap<String, String>();
                tPrdCondition.put("name", tProductName);
                tPrdCondition.put("uid", ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
                List<Product> tProducts = this.productDao.fetch(tPrdCondition);
                String tEocSetting = "";
                String tEocSettingRegion = "";
                if (tProducts != null && !tProducts.isEmpty() && tProducts.get(0).getEocSetting() != null) {
                    tEocSetting = tProducts.get(0).getEocSetting();
                    tEocSettingRegion = tProducts.get(0).getEocSettingRegion();
                }
                tProdEocMappingObjectNode.put("eoc_setting", tEocSetting);
                tProdEocMappingObjectNode.put("eoc_setting_region", tEocSettingRegion);
            }
            tProdEocMappingObjectNode.put("prod_name", tProductName);
            tProdEocMappingObjectNode.put("uid", ((EocIntgMapping)((List)tMappingsGroupByProductName.get(tProductName)).get(0)).getProductUid());
            ArrayNode orgTypeMapping = this.mapper.createArrayNode();
            tProdEocMappingObjectNode.set("org_type_mapping", (JsonNode)orgTypeMapping);
            for (EocIntgMapping mapping : (List)tMappingsGroupByProductName.get(tProductName)) {
                ArrayNode tIntgCompanyAryNode;
                ObjectNode orgTypeMappingNode = this.mapper.createObjectNode();
                orgTypeMappingNode.put("eoc_mapping_id", mapping.getEocId());
                orgTypeMappingNode.put("om_mapping_id", mapping.getIntgId());
                if (pNameInclude.booleanValue() && tEocNode.get(mapping.getEocId()) != null) {
                    orgTypeMappingNode.put("eoc_mapping_name", (String)tEocNode.get(mapping.getEocId()));
                }
                if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.enterprise_id.toString())) {
                    orgTypeMappingNode.put("type", "enterprise_id");
                } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.company_id.toString())) {
                    orgTypeMappingNode.put("type", "company_id");
                    if (tIntgInfoNode != null) {
                        tIntgCompanyAryNode = (ArrayNode)tIntgInfoNode.get("org_type_company");
                        for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
                            if (!mapping.getIntgId().equals(tIntgCompanyObject.get("company_no").asText())) continue;
                            orgTypeMappingNode.set("om_mapping_name", tIntgCompanyObject.get("company_name"));
                        }
                    }
                } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.site_id.toString())) {
                    orgTypeMappingNode.put("type", "site_id");
                    if (tIntgInfoNode != null) {
                        tIntgCompanyAryNode = (ArrayNode)tIntgInfoNode.get("org_type_company");
                        for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
                            if (tIntgCompanyObject.get("org_type_site") == null) continue;
                            for (JsonNode tIntgSiteObject : tIntgCompanyObject.get("org_type_site")) {
                                if (!mapping.getIntgId().equals(tIntgSiteObject.get("site_no").asText())) continue;
                                orgTypeMappingNode.set("om_mapping_name", tIntgSiteObject.get("site_name"));
                            }
                        }
                    }
                } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.region_id.toString())) {
                    ArrayNode tIntgRegionAryNode;
                    orgTypeMappingNode.put("type", "region_id");
                    if (tIntgInfoNode != null && (tIntgRegionAryNode = (ArrayNode)tIntgInfoNode.get("org_type_region")) != null) {
                        for (JsonNode tIntgRegionObject : tIntgRegionAryNode) {
                            if (!mapping.getIntgId().equals(tIntgRegionObject.get("region_no").asText())) continue;
                            orgTypeMappingNode.set("om_mapping_name", tIntgRegionObject.get("region_name"));
                        }
                    }
                }
                orgTypeMapping.add((JsonNode)orgTypeMappingNode);
            }
            tProdEocMappingAryNode.add((JsonNode)tProdEocMappingObjectNode);
        }
        StateCode stateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(stateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(stateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("prod_eoc_mapping", (JsonNode)tProdEocMappingAryNode);
        tResponseJsonNode.put("tenant_id", pTenantId);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    public Map<String, Object> processTenantProdOperationListGetV2(String pTenantId, String pProdName, String pUid, String pId) {
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("prod_name", pProdName);
        pCondition.put("eoc_level", "cloud_mapping_id");
        if (pUid != null) {
            pCondition.put("uid", pUid);
        }
        List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetch(pCondition);
        ArrayNode orgTypeMapping = this.mapper.createArrayNode();
        for (EocIntgMapping mapping : tMappings) {
            ObjectNode orgTypeMappingNode = this.mapper.createObjectNode();
            orgTypeMappingNode.put("eoc_mapping_id", mapping.getEocId());
            orgTypeMappingNode.put("om_mapping_id", mapping.getIntgId());
            if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.enterprise_id.toString())) {
                orgTypeMappingNode.put("type", "enterprise_id");
            } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.company_id.toString())) {
                orgTypeMappingNode.put("type", "company_id");
            } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.site_id.toString())) {
                orgTypeMappingNode.put("type", "site_id");
            } else if (mapping.getCloudMappingType().equalsIgnoreCase(EocLevelEnum.region_id.toString())) {
                orgTypeMappingNode.put("type", "region_id");
            }
            orgTypeMapping.add((JsonNode)orgTypeMappingNode);
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("org_type_mapping", (JsonNode)orgTypeMapping);
        tResponseJsonNode.put("tenant_id", pTenantId);
        tResponseJsonNode.put("prod_name", pProdName);
        if (!tMappings.isEmpty()) {
            tResponseJsonNode.put("uid", tMappings.get(0).getProductUid());
            tResponseJsonNode.put("prod_type", ApiTypeEnum.standard.toString());
            tResponseJsonNode.put("url", "");
        } else {
            HashMap<String, String> tAgileAppCondition = new HashMap<String, String>();
            tAgileAppCondition.put("product_type", ApiTypeEnum.agile.toString());
            tAgileAppCondition.put("name", pProdName);
            if (pId != null) {
                tAgileAppCondition.put("id", pId);
            } else if (pUid != null) {
                tAgileAppCondition.put("uid", pUid);
            }
            List<Product> tAgileAppList = this.productDao.fetch(tAgileAppCondition);
            if (tAgileAppList != null && !tAgileAppList.isEmpty()) {
                tResponseJsonNode.put("uid", tAgileAppList.get(0).getUid());
                tResponseJsonNode.put("prod_type", ApiTypeEnum.agile.toString());
                tResponseJsonNode.put("url", tAgileAppList.get(0).getUrl());
            }
        }
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

