/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.Api;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UcTenantListGetService
extends AbstractApiService {
    @Autowired
    private ApiDao apiDao;

    public UcTenantListGetService() {
        this.jsonSchemaFileName = "uc_tenant_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        ObjectNode tDataNode = this.mapper.createObjectNode();
        ArrayNode tTenantIdAryNode = this.mapper.createArrayNode();
        tDataNode.set("tenant_list", (JsonNode)tTenantIdAryNode);
        String tApiName = null;
        if (tRequestJsonNode.get("api_name") != null && tRequestJsonNode.get("api_name").asText().length() != 0) {
            tApiName = tRequestJsonNode.get("api_name").asText();
        }
        this.log.info((Object)("tApiName" + tApiName));
        List<Api> tUcApiList = this.apiDao.getUcApi();
        ArrayList<String> tTenantList = new ArrayList<String>();
        for (Api tApi : tUcApiList) {
            if (StringUtil.isEmptyOrSpace(tApi.getTenantId()) || tTenantList.contains(tApi.getTenantId())) continue;
            tTenantList.add(tApi.getTenantId());
            tTenantIdAryNode.add(tApi.getTenantId());
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

