/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.config;

import nl.altindag.ssl.SSLFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ESConfig {
    @Value(value="${elasticsearch.host}")
    private String host;
    @Value(value="${elasticsearch.port}")
    private int port;
    @Value(value="${elasticsearch.userName}")
    private String userName;
    @Value(value="${elasticsearch.password}")
    private String password;

    @Bean
    public RestClientBuilder restClientBuilder() {
        SSLFactory sslFactory = SSLFactory.builder().withUnsafeTrustMaterial().withUnsafeHostnameVerifier().build();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.userName, this.password));
        HttpHost httpHost = new HttpHost(this.host, this.port, "https");
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{httpHost});
        restClientBuilder.setHttpClientConfigCallback(arg_0 -> ESConfig.lambda$restClientBuilder$1((CredentialsProvider)credentialsProvider, sslFactory, arg_0));
        restClientBuilder.setRequestConfigCallback(hc -> hc.setConnectTimeout(5000).setSocketTimeout(60000));
        return restClientBuilder;
    }

    @Bean
    public RestHighLevelClient highLevelClient(@Autowired RestClientBuilder restClientBuilder) {
        return new RestHighLevelClient(restClientBuilder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$restClientBuilder$1(CredentialsProvider credentialsProvider, SSLFactory sslFactory, HttpAsyncClientBuilder hc) {
        return hc.setDefaultCredentialsProvider(credentialsProvider).setSSLContext(sslFactory.getSslContext()).setSSLHostnameVerifier(sslFactory.getHostnameVerifier()).setKeepAliveStrategy((response, context) -> 180000L);
    }
}

