/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.AssetIndustryWordDictionaryDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import com.digiwin.metadatacache.model.AssetIndustryWordDictionary;
import com.digiwin.metadatacache.model.IndustryWordResponse;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="mdcTransactionManager")
public class AssetIndustryWordDictionaryDaoImpl
extends GenericDaoImpl<AssetIndustryWordDictionary, Long>
implements AssetIndustryWordDictionaryDao {
    public AssetIndustryWordDictionaryDaoImpl() {
        super(AssetIndustryWordDictionary.class);
    }

    @Override
    public List<IndustryWordResponse> queryByInfo(String standardWordNo, String standardWordName, String industryTerm) {
        return (List)this.getHibernateTemplate().execute(session -> {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SELECT aswd.data_name AS dataName, aswd.description_zh_cn AS descriptionZhCn,\nai.industry_no AS industryNo, ai.industry_name AS industryName, ait.industry_term_zh_cn AS industryTermZhCn,\nasb.data_type AS dataType, asb.size, asb.field_precision AS fieldPrecision");
            stringBuilder.append(" FROM asset_standard_word_dictionary aswd");
            stringBuilder.append(" LEFT JOIN asset_industry_word_dictionary aiwd ON aiwd.standard_word_no = aswd.data_name");
            stringBuilder.append(" LEFT JOIN asset_standard_businesstype asb ON aswd.relate_business_type_id = asb.id");
            stringBuilder.append(" LEFT JOIN asset_industry_term ait ON aiwd.industry_term_id = ait.industry_term_id");
            if (null != industryTerm) {
                stringBuilder.append(" AND (ait.industry_term_zh_tw LIKE '%").append(industryTerm).append("%'");
                stringBuilder.append(" OR ait.industry_term_zh_cn LIKE '%").append(industryTerm).append("%'");
                stringBuilder.append(" OR ait.industry_term_en_us LIKE '%").append(industryTerm).append("%')");
            }
            stringBuilder.append(" LEFT JOIN asset_industry ai ON ait.industry_id = ai.industry_id");
            stringBuilder.append(" WHERE 1 = 1");
            if (null != standardWordNo) {
                stringBuilder.append(" AND aswd.data_name = :standardWordNo ");
            }
            if (null != standardWordName) {
                stringBuilder.append(" AND (aswd.description_zh_tw LIKE '%").append(standardWordName).append("%'");
                stringBuilder.append(" OR aswd.description_zh_cn LIKE '%").append(standardWordName).append("%'");
                stringBuilder.append(" OR aswd.description_en_us LIKE '%").append(standardWordName).append("%')");
            }
            NativeQuery tQuery = session.createNativeQuery(stringBuilder.toString(), IndustryWordResponse.class);
            if (null != standardWordNo) {
                tQuery.setParameter("standardWordNo", (Object)standardWordNo);
            }
            this.log.info((Object)("\u67e5\u8be2\u8bed\u53e5\u6253\u5370: " + tQuery.getQueryString()));
            return tQuery.list();
        });
    }
}

