/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.services.MdcCacheService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="mdcTransactionManager")
public class EocIntgMappingDaoImpl
extends GenericDaoImpl<EocIntgMapping, Long>
implements EocIntgMappingDao {
    @Autowired
    protected MdcCacheService cacheService;

    public EocIntgMappingDaoImpl() {
        super(EocIntgMapping.class);
    }

    @Override
    public List<EocIntgMapping> fetch(Map<String, String> pConditions) {
        return (List)this.getHibernateTemplate().execute(pSession -> {
            Criteria tCriteria = EocIntgMappingDaoImpl.getCriteria(pSession, pConditions);
            return tCriteria.list();
        });
    }

    private static Criteria getCriteria(Session pSession, Map<String, String> pConditions) {
        Criteria tCriteria = pSession.createCriteria(EocIntgMapping.class);
        tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        if (pConditions.containsKey("tenant_id")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"tenantId", (Object)pConditions.get("tenant_id")));
        }
        if (pConditions.containsKey("prod_name")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"productName", (Object)pConditions.get("prod_name")));
        }
        if (pConditions.containsKey("eoc_id")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"eocId", (Object)pConditions.get("eoc_id")));
        }
        if (pConditions.containsKey("eoc_level")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"eocLevel", (Object)pConditions.get("eoc_level")));
        }
        if (pConditions.containsKey("product_uid")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"productUid", (Object)pConditions.get("product_uid")));
        }
        if (pConditions.containsKey("intg_id")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"intgId", (Object)pConditions.get("intg_id")));
        }
        if (pConditions.containsKey("region_type")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"regionType", (Object)pConditions.get("region_type")));
        }
        if (pConditions.containsKey("uid")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"productUid", (Object)pConditions.get("uid")));
        }
        if (pConditions.containsKey("cloud_mapping_type")) {
            tCriteria.add((Criterion)Restrictions.eq((String)"cloudMappingType", (Object)pConditions.get("cloud_mapping_type")));
        }
        return tCriteria;
    }

    @Override
    public List<EocIntgMapping> fetchGroupByEocId(Map<String, String> pConditions) {
        List<EocIntgMapping> list = this.fetch(pConditions);
        return list.stream().collect(Collectors.collectingAndThen(Collectors.toMap(EocIntgMapping::getEocId, p -> p, (p, q) -> p), map -> new ArrayList(map.values())));
    }

    @Override
    public List<EocIntgMapping> updateList(List<EocIntgMapping> pList) {
        for (EocIntgMapping tMapping : pList) {
            this.save(tMapping);
        }
        if (!pList.isEmpty()) {
            this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + ":" + pList.get(0).getTenantId() + "*");
            this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + pList.get(0).getTenantId() + "*");
            this.cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
            String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + pList.get(0).getTenantId();
            this.cacheService.remove(tKey);
            this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1akey = " + tKey));
            this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1atenant = " + pList.get(0).getTenantId()));
        }
        return pList;
    }

    @Override
    public List<EocIntgMapping> updateCloudList(List<EocIntgMapping> pList) {
        for (EocIntgMapping tMapping : pList) {
            this.save(tMapping);
        }
        return pList;
    }

    @Override
    public void clearList(final String pTenantId, final String pProductUid) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<EocIntgMapping>(){

            public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
                Query tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid");
                tQ.setParameter("tenantId", (Object)pTenantId);
                tQ.setParameter("productUid", (Object)pProductUid);
                tQ.executeUpdate();
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + ":" + pTenantId + "*");
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + pTenantId + "*");
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
                String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + pTenantId;
                EocIntgMappingDaoImpl.this.cacheService.remove(tKey);
                EocIntgMappingDaoImpl.this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1akey = " + tKey));
                EocIntgMappingDaoImpl.this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1atenant = " + pTenantId));
                return null;
            }
        });
    }

    @Override
    public void deleteChildMapping(final long pId) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<EocIntgMapping>(){

            public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
                Query tQ = pSession.createQuery("delete EocIntgMapping where eocIntgMapping.id is :id");
                tQ.setParameter("id", (Object)pId);
                tQ.executeUpdate();
                return null;
            }
        });
    }

    @Override
    public List<EocIntgMapping> getChildMapping(final long pId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<EocIntgMapping>>(){

            public List<EocIntgMapping> doInHibernate(Session pSession) throws HibernateException {
                StringBuilder tHqlSB = new StringBuilder();
                tHqlSB.append("from EocIntgMapping where eocIntgMapping.id is :id");
                Query tQuery = pSession.createQuery(tHqlSB.toString(), EocIntgMapping.class);
                tQuery.setParameter("id", (Object)pId);
                return tQuery.getResultList();
            }
        });
    }

    @Override
    public void clearListWithLevel(final String pTenantId, final String pProductUid, final String pLevel) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<EocIntgMapping>(){

            public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
                if (pLevel.equals("Company")) {
                    Query tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is not :eocLevel");
                    tQ.setParameter("tenantId", (Object)pTenantId);
                    tQ.setParameter("productUid", (Object)pProductUid);
                    tQ.setParameter("eocLevel", (Object)"region_id");
                    tQ.executeUpdate();
                    EocIntgMappingDaoImpl.this.log.info((Object)("\u522a\u9664\u904b\u71df\u914d\u7f6e\u8cc7\u6599: \u79df\u6236 = " + pTenantId + ", \u7522\u54c1\u4e3b\u6a5f = " + pProductUid + ", \u5c64\u7d1a = \u516c\u53f8/\u5de5\u5ee0"));
                } else if (pLevel.equals("Region")) {
                    Query tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is :eocLevel");
                    tQ.setParameter("tenantId", (Object)pTenantId);
                    tQ.setParameter("productUid", (Object)pProductUid);
                    tQ.setParameter("eocLevel", (Object)"region_id");
                    tQ.executeUpdate();
                    EocIntgMappingDaoImpl.this.log.info((Object)("\u522a\u9664\u904b\u71df\u914d\u7f6e\u8cc7\u6599: \u79df\u6236 = " + pTenantId + ", \u7522\u54c1\u4e3b\u6a5f = " + pProductUid + ", \u5c64\u7d1a = \u5834\u57df"));
                } else if (pLevel.equals("All")) {
                    Query tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid");
                    tQ.setParameter("tenantId", (Object)pTenantId);
                    tQ.setParameter("productUid", (Object)pProductUid);
                    tQ.executeUpdate();
                    EocIntgMappingDaoImpl.this.log.info((Object)("\u522a\u9664\u904b\u71df\u914d\u7f6e\u8cc7\u6599: \u79df\u6236 = " + pTenantId + ", \u7522\u54c1\u4e3b\u6a5f = " + pProductUid + ", \u5c64\u7d1a = \u5168\u5c64\u7d1a"));
                }
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + ":" + pTenantId + "*");
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + pTenantId + "*");
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
                String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + pTenantId;
                EocIntgMappingDaoImpl.this.cacheService.remove(tKey);
                EocIntgMappingDaoImpl.this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1akey = " + tKey));
                EocIntgMappingDaoImpl.this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1atenant = " + pTenantId));
                return null;
            }
        });
    }

    @Override
    public void deleteMapping(final String pTenantId, final String pLevel, final String pUid, final String pProdName, final String pEocId, final String pOmId) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<EocIntgMapping>(){

            public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
                Query tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is :eocLevel and productName is :prodName and eocId is :eocId and intgId is :omId");
                tQ.setParameter("tenantId", (Object)pTenantId);
                tQ.setParameter("productUid", (Object)pUid);
                tQ.setParameter("eocLevel", (Object)pLevel);
                tQ.setParameter("prodName", (Object)pProdName);
                tQ.setParameter("eocId", (Object)pEocId);
                tQ.setParameter("omId", (Object)pOmId);
                tQ.executeUpdate();
                EocIntgMappingDaoImpl.this.log.info((Object)("\u522a\u9664\u904b\u71df\u914d\u7f6e\u8cc7\u6599: \u79df\u6236 = " + pTenantId + ", \u7522\u54c1\u4e3b\u6a5f = " + pUid + ", \u5c64\u7d1a = " + pLevel + ", eoc = " + pEocId + ", om = " + pOmId));
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + ":" + pTenantId + "*");
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + pTenantId + "*");
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
                String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + pTenantId;
                EocIntgMappingDaoImpl.this.cacheService.remove(tKey);
                EocIntgMappingDaoImpl.this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1akey = " + tKey));
                EocIntgMappingDaoImpl.this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1atenant = " + pTenantId));
                return null;
            }
        });
    }

    @Override
    public void deleteCloudMapping(final String pTenantId, final String pLevel, final String cloudMappingType, final String pUid, final String productName, final String pEocId, final String intgId) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<EocIntgMapping>(){

            public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
                Query tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is :eocLevel and cloudMappingType is :cloudMappingType and productName is :productName and eocId is :eocId and intgId is :intgId");
                tQ.setParameter("tenantId", (Object)pTenantId);
                tQ.setParameter("productUid", (Object)pUid);
                tQ.setParameter("eocLevel", (Object)pLevel);
                tQ.setParameter("cloudMappingType", (Object)cloudMappingType);
                tQ.setParameter("productName", (Object)productName);
                tQ.setParameter("eocId", (Object)pEocId);
                tQ.setParameter("intgId", (Object)intgId);
                tQ.executeUpdate();
                EocIntgMappingDaoImpl.this.log.info((Object)("\u522a\u9664\u4e91\u5730\u6620\u5c04\u904b\u71df\u914d\u7f6e\u8cc7\u6599: \u79df\u6236 = " + pTenantId + ", \u7522\u54c1\u4e3b\u6a5f = " + pUid + ", \u5c64\u7d1a = " + cloudMappingType + ", eoc = " + pEocId + ", om = " + intgId + ",  eocLevel=" + pLevel + ",  prodName=" + productName));
                return null;
            }
        });
    }

    @Override
    public void deleteCloudMapping(final String pTenantId, final String pProductUid, final String pLevel, final String cloudMappingType, final String productName) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<EocIntgMapping>(){

            public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
                Query tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId and productUid is :productUid and eocLevel is :eocLevel and cloudMappingType is :cloudMappingType and productName is :productName");
                tQ.setParameter("tenantId", (Object)pTenantId);
                tQ.setParameter("productUid", (Object)pProductUid);
                tQ.setParameter("eocLevel", (Object)pLevel);
                tQ.setParameter("cloudMappingType", (Object)cloudMappingType);
                tQ.setParameter("productName", (Object)productName);
                tQ.executeUpdate();
                EocIntgMappingDaoImpl.this.log.info((Object)("\u522a\u9664\u904b\u71df\u914d\u7f6e\u8cc7\u6599: \u79df\u6236 = " + pTenantId + ", \u7522\u54c1\u4e3b\u6a5f = " + pProductUid + ", \u5c64\u7d1a = " + cloudMappingType + ", eocLevel=" + pLevel));
                return null;
            }
        });
    }

    @Override
    public void deleteMappingByTenantId(final String pTenantId) {
        this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<EocIntgMapping>(){

            public EocIntgMapping doInHibernate(Session pSession) throws HibernateException {
                Query tQ = pSession.createQuery("delete EocIntgMapping where tenantId is :tenantId");
                tQ.setParameter("tenantId", (Object)pTenantId);
                tQ.executeUpdate();
                EocIntgMappingDaoImpl.this.log.info((Object)("\u522a\u9664\u79df\u6236\u6240\u6709\u904b\u71df\u914d\u7f6e\u8cc7\u6599: \u79df\u6236 = " + pTenantId));
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + ":" + pTenantId + "*");
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + pTenantId + "*");
                EocIntgMappingDaoImpl.this.cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + "*");
                String tKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + pTenantId;
                EocIntgMappingDaoImpl.this.cacheService.remove(tKey);
                EocIntgMappingDaoImpl.this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1akey = " + tKey));
                EocIntgMappingDaoImpl.this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u6e05\u9664\u5feb\u53d6(\u79df\u6236\u7684\u6574\u500b\u7522\u54c1\u6e05\u55ae)\uff1atenant = " + pTenantId));
                return null;
            }
        });
    }
}

