/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.StateCodeDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import com.digiwin.metadatacache.model.StateCode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class StateCodeDaoImpl
extends GenericDaoImpl<StateCode, String>
implements StateCodeDao {
    private static Map<String, StateCode> STATE_MAP = new HashMap<String, StateCode>();

    public StateCodeDaoImpl() {
        super(StateCode.class);
    }

    @PostConstruct
    public void init() {
        List<StateCode> states = this.getAll();
        if (CollectionUtils.isNotEmpty(states)) {
            states.forEach(one -> STATE_MAP.put(one.getCode(), (StateCode)one));
        }
    }

    @Override
    public StateCode getStateCodeByCode(String pStateCode) {
        StateCode code = STATE_MAP.get(pStateCode);
        if (code != null) {
            return code;
        }
        code = (StateCode)this.get(pStateCode);
        if (code != null) {
            STATE_MAP.put(code.getCode(), code);
        }
        return code;
    }
}

