/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.app.eai.DWEAI;
import com.digiwin.app.eai.DWEAIBuilder;
import com.digiwin.app.eai.DigiHost;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.exception.OmInfoRetrievedFailedException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntgInfoService {
    private final Log log = LogFactory.getLog(this.getClass());
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    public JsonNode getIntgInfo(String pEntId, String pTenantId, String pProdName, String pUid) throws Exception {
        try {
            DWEAI tDWEAI;
            Map tResponseMap;
            Map tResponseHeaders;
            this.log.info((Object)("\u8abf\u7528\u5730\u7aef\u7522\u54c1\u53d6\u5f97om\u4ee3\u78bc\u6e05\u55ae\uff0cEntId\uff1a" + pEntId + " TenantId\uff1a" + pTenantId + " ProdName\uff1a" + pProdName + " Uid\uff1a" + pUid));
            String tAcct = "";
            switch (pProdName) {
                case "E10": {
                    tAcct = "dcms";
                    break;
                }
                case "WFGP": {
                    tAcct = "DS";
                    break;
                }
                case "TIPTOP": 
                case "T100": {
                    tAcct = "tiptop";
                }
            }
            String version = IamVerifyServiceUtil.getCurrentTenantVersion(pTenantId);
            HashMap<String, String> pEocIntgMappingMapCondition = new HashMap<String, String>();
            if ("v1".equalsIgnoreCase(version)) {
                pEocIntgMappingMapCondition.put("eoc_level", "enterprise_id");
                pEocIntgMappingMapCondition.put("tenant_id", pTenantId);
                pEocIntgMappingMapCondition.put("uid", pUid);
            } else {
                pEocIntgMappingMapCondition.put("eoc_level", "cloud_mapping_id");
                pEocIntgMappingMapCondition.put("cloud_mapping_type", "enterprise_id");
                pEocIntgMappingMapCondition.put("tenant_id", pTenantId);
                pEocIntgMappingMapCondition.put("uid", pUid);
            }
            List<EocIntgMapping> eocIntgMappings = this.eocIntgMappingDao.fetch(pEocIntgMappingMapCondition);
            JsonObject tDatakeyObject = new JsonObject();
            if (pEntId != null && pEntId.length() != 0) {
                tDatakeyObject.addProperty("EntId", pEntId);
            } else if (!eocIntgMappings.isEmpty()) {
                tDatakeyObject.addProperty("EntId", eocIntgMappings.get(0).getEocId());
            }
            Map tBody = (Map)this.mapper.convertValue((Object)this.mapper.readTree("{ \"enterprise_no\": \"\", \"site_no\": \"\", \"call_id\": \"\" }"), (TypeReference)new TypeReference<Map<String, Object>>(){});
            String locale = DWServiceContext.getContext().getRequestHeader().getOrDefault("locale", System.getenv("message_language")).toString();
            DWEAIBuilder tDWEAIBuilder = new DWEAIBuilder(pProdName, "valid.organization.data.get", tBody).setDigiHostLang(DigiHost.lang.valueOf((String)locale)).setDigiHostAcct(tAcct).setDigiServiceUid(pUid).setDigiDatakey(tDatakeyObject.toString()).sync();
            tDWEAIBuilder.getDigiService().setTenantId(pTenantId);
            HashMap<String, String> customHeader = new HashMap<String, String>();
            if (null != DWServiceContext.getContext().getRequestHeader().get("token")) {
                customHeader.put("token", DWServiceContext.getContext().getRequestHeader().get("token").toString());
                tDWEAIBuilder.setCustomHeader(customHeader);
            }
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                customHeader.put("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
                tDWEAIBuilder.setCustomHeader(customHeader);
            }
            if (!"019".equals((tResponseHeaders = (Map)(tResponseMap = (tDWEAI = tDWEAIBuilder.build()).execute()).get("headers")).get("digi-code"))) {
                String tSB = tResponseHeaders.get("digi-message").toString() + " digi-reqid: " + tResponseHeaders.get("digi-reqid").toString();
                throw new OmInfoRetrievedFailedException(tSB, this.getClass());
            }
            String tResponseBody = (String)tResponseMap.get("messageBody");
            if (StringUtil.isEmptyOrSpace(tResponseBody)) {
                String tSB = pProdName + " response is empty. digi-reqid: " + tResponseHeaders.get("digi-reqid").toString();
                throw new OmInfoRetrievedFailedException(tSB, this.getClass());
            }
            JsonNode tERPIntgReturnNode = this.mapper.readTree(tResponseBody);
            if (!"000".equals(tResponseHeaders.get("digi-srvcode"))) {
                String tSB = pProdName + " response: " + tERPIntgReturnNode.get("std_data").get("execution").get("description").asText() + " digi-reqid: " + tResponseHeaders.get("digi-reqid").toString();
                throw new OmInfoRetrievedFailedException(tSB, this.getClass());
            }
            JsonNode tIntgNode = tERPIntgReturnNode.get("std_data").get("parameter");
            this.log.info((Object)("\u8abf\u7528\u5730\u7aef\u7522\u54c1\u53d6\u5f97om\u4ee3\u78bc\u6e05\u55ae\u6210\u529f\uff0com\u6e05\u55ae\uff1a" + tIntgNode.toString()));
            return tIntgNode;
        }
        catch (DWHttpFailedException e) {
            Map tFailedEntity = (Map)e.getEntity(Map.class);
            String tMsg = String.format("response: %s", tFailedEntity.get("message"));
            throw new OmInfoRetrievedFailedException(tMsg, this.getClass());
        }
    }
}

