/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.metadatacache.services.RedissonService;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdcCacheService {
    private final Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private DWRedisService redisService;
    @Autowired
    private RedissonService redissonService;
    private ThreadPoolExecutor poolExecutor = new ThreadPoolExecutor(10, 50, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(50), new ThreadPoolExecutor.CallerRunsPolicy());

    public String getCacheMapValue(String pCacheMapKey, String pKey) {
        try {
            return (String)this.redisService.get(pCacheMapKey + ":" + pKey);
        }
        catch (Exception e) {
            this.log.warn((Object)("\u8bf7\u6c42redis\u5f02\u5e38\u65b9\u6cd5:getCacheMapValue() " + pCacheMapKey + "--" + pKey), (Throwable)e);
            return null;
        }
    }

    public Object get(String pKey) {
        try {
            return this.redisService.get(pKey);
        }
        catch (Exception e) {
            this.log.warn((Object)("\u8bf7\u6c42redis\u5f02\u5e38:get() " + pKey), (Throwable)e);
            return null;
        }
    }

    public void remove(String pKey) {
        this.executionAndRetry(pKey, () -> this.redisService.remove(new String[]{pKey}));
    }

    public void set(String pKey, Object pValue) {
        this.executionAndRetry(pKey, () -> this.redisService.set(pKey, pValue, this.getOneDayWithRandomLiveSeconds()));
    }

    public void setSync(String pKey, Object pValue) {
        this.executionAndRetry(pKey, () -> this.redisService.set(pKey, pValue, this.getOneDayWithRandomLiveSeconds()));
    }

    public void setSyncTimeOut(String pKey, Object pValue, long timeout) {
        this.executionAndRetry(pKey, () -> this.redisService.set(pKey, pValue, timeout));
    }

    public void setCacheMapValue(String pCacheMapKey, String pKey, String pValue) {
        String tErrorMsgKey = pCacheMapKey + ' ' + pKey;
        this.executionAndRetry(tErrorMsgKey, () -> this.redisService.set(pCacheMapKey + ":" + pKey, (Object)pValue, this.getOneDayWithRandomLiveSeconds()));
    }

    public void removeCacheMapValueContainsWord(String pCacheMapKey, String pWord) {
        String tErrorMsgKey = pCacheMapKey + ' ' + pWord;
        this.executionAndRetry(tErrorMsgKey, () -> {
            String pattern = pCacheMapKey + "*";
            Set keys = this.redisService.keys(pattern);
            if (CollectionUtils.isNotEmpty((Collection)keys)) {
                keys.forEach(one -> {
                    if (StringUtils.substringAfter((String)one, (String)pattern).contains(pWord)) {
                        this.redisService.remove(new String[]{one});
                    }
                });
            }
        });
    }

    public void removeByPattern(String pKeyPattern) {
        this.executionAndRetry(pKeyPattern, () -> {
            Set keys = this.redisService.keys(pKeyPattern);
            for (String key : keys) {
                this.redisService.remove(new String[]{key});
            }
        });
    }

    public Set<String> getKeysByPattern(String pKeyPattern) {
        return this.redisService.keys(pKeyPattern);
    }

    private void executionAndRetry(String pErrorMsgKey, CacheExecutionHandler pHandler) {
        this.poolExecutor.execute(() -> {
            int tRetryTimes = 2;
            while (true) {
                try {
                    pHandler.execute();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                    if (--tRetryTimes <= 0) break;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e1) {
                        this.log.error((Object)e1);
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                break;
            }
        });
    }

    public boolean lock(String pLockKey) throws InterruptedException {
        return this.redissonService.lock(pLockKey);
    }

    public void unLock(String pLockKey) {
        this.redissonService.unLock(pLockKey);
    }

    private long getOneDayWithRandomLiveSeconds() {
        int liveTime = 1440 + RandomUtils.nextInt((int)0, (int)360);
        return TimeUnit.MINUTES.toSeconds(liveTime);
    }

    private static interface CacheExecutionHandler {
        public void execute();
    }
}

