/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdUtil {
    private static final Logger logger = LoggerFactory.getLogger(IdUtil.class);
    private static final Pattern PATTERN_HOSTNAME = Pattern.compile("^.*\\D+([0-9]+)$");
    private static final long START_TIME = 1609430400L;
    private static final long MAX_NEXT = 65535L;
    private static final long SHARD_ID = IdUtil.getServerIdAsLong();
    private static long offset = 0L;
    private static long lastEpoch = 0L;

    private IdUtil() {
    }

    public static long nextId() {
        return IdUtil.nextId(System.currentTimeMillis() / 1000L);
    }

    private static synchronized long nextId(long epochSecond) {
        long next;
        if (epochSecond < lastEpoch) {
            logger.warn("clock is back: {} from previous: {}", (Object)epochSecond, (Object)lastEpoch);
            epochSecond = lastEpoch;
        }
        if (lastEpoch != epochSecond) {
            lastEpoch = epochSecond;
            offset = 0L;
        }
        if ((next = ++offset & 0xFFFFL) == 0L) {
            logger.warn("maximum id reached in 1 second in epoch: {}", (Object)epochSecond);
            return IdUtil.nextId(epochSecond + 1L);
        }
        return IdUtil.generateId(epochSecond, next);
    }

    private static long generateId(long epochSecond, long next) {
        return epochSecond - 1609430400L << 21 | next << 5 | SHARD_ID;
    }

    private static long getServerIdAsLong() {
        try {
            long n;
            String hostname = InetAddress.getLocalHost().getHostName();
            Matcher matcher = PATTERN_HOSTNAME.matcher(hostname);
            if (matcher.matches() && (n = Long.parseLong(matcher.group(1))) >= 0L && n < 8L) {
                logger.info("detect server id from host name {}: {}.", (Object)hostname, (Object)n);
                return n;
            }
        }
        catch (UnknownHostException e) {
            logger.warn("unable to get host name. set server id = 0.");
        }
        return 0L;
    }
}

