/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.ApiRelationDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.exception.TokenNotRetrievedException;
import com.digiwin.metadatacache.model.ApiRelation;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.services.LocalCacheService;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDateTime;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiRelationDeleteService
extends AbstractApiService {
    @Autowired
    private ApiRelationDao apiRelationDao;
    @Autowired
    private LocalCacheService localCacheService;

    public ApiRelationDeleteService() {
        this.jsonSchemaFileName = "api_relation_delete.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tToken = (String)DWServiceContext.getContext().getRequestHeader().get("token");
        if (null == tToken) {
            throw new TokenNotRetrievedException(this.getClass());
        }
        String userName = IamVerifyServiceUtil.getUserName(tToken);
        String apiName = tRequestJsonNode.get("api_name").asText();
        String tenantId = null;
        if (null != tRequestJsonNode.get("tenant_id") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("tenant_id").asText())) {
            tenantId = tRequestJsonNode.get("tenant_id").asText();
        }
        this.deleteApiRelation(userName, apiName, tenantId);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    public void deleteApiRelation(String userName, String apiName, String tenantId) {
        ApiRelation apiRelation = this.apiRelationDao.getRelationBySubInfo(apiName, tenantId);
        if (null != apiRelation) {
            apiRelation.setUpdateId(userName);
            apiRelation.setDeleteFlag(1);
            apiRelation.setUpdateTime(LocalDateTime.now());
            this.apiRelationDao.saveOrupdate(apiRelation);
            this.localCacheService.remove(CacheMapTypeEnum.api_relation_idempotency_cachemap, apiRelation.getSubApiName());
        }
    }
}

