/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.AppSupportVersionDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.exception.TenantIDNotFoundException;
import com.digiwin.metadatacache.model.AppSupportVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppSupportVersionGetService
extends AbstractApiService {
    @Autowired
    private AppSupportVersionDao appSupportVersionDao;

    public AppSupportVersionGetService() {
        this.jsonSchemaFileName = "app_support_version_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tAppId = tRequestJsonNode.get("appid").asText();
        String tVersion = tRequestJsonNode.get("version").asText();
        HashMap<String, String> tConditions = new HashMap<String, String>();
        tConditions.put("appid", tAppId);
        tConditions.put("version", tVersion);
        List<AppSupportVersion> tAppSupportVersionList = this.appSupportVersionDao.fetch(tConditions);
        if (tAppSupportVersionList == null || tAppSupportVersionList.isEmpty()) {
            throw new TenantIDNotFoundException(this.getClass());
        }
        ObjectNode tDataNode = this.mapper.createObjectNode();
        ArrayNode tVersionAryNode = this.mapper.createArrayNode();
        for (AppSupportVersion tAppSupportVersion : tAppSupportVersionList) {
            tVersionAryNode.add(tAppSupportVersion.getTenantId().trim());
        }
        tDataNode.set("tenant_id", (JsonNode)tVersionAryNode);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

