/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.AssetIndustryWordDictionaryDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.IndustryWordResponse;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetIndustryVocabularyListGetService
extends AbstractApiService {
    @Autowired
    private AssetIndustryWordDictionaryDao assetIndustryWordDictionaryDao;

    public AssetIndustryVocabularyListGetService() {
        this.jsonSchemaFileName = "asset_industry_vocabulary_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String standardWordNo = null;
        if (null != tRequestJsonNode.get("standard_word_no") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("standard_word_no").asText())) {
            standardWordNo = tRequestJsonNode.get("standard_word_no").asText();
        }
        String standardWordName = null;
        if (null != tRequestJsonNode.get("standard_word_name") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("standard_word_name").asText())) {
            standardWordName = tRequestJsonNode.get("standard_word_name").asText();
        }
        String industryTerm = null;
        if (null != tRequestJsonNode.get("industry_term") && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("industry_term").asText())) {
            industryTerm = tRequestJsonNode.get("industry_term").asText();
        }
        List<IndustryWordResponse> industryWordResponseList = this.assetIndustryWordDictionaryDao.queryByInfo(standardWordNo, standardWordName, industryTerm);
        ObjectNode tDataNode = this.mapper.createObjectNode();
        ArrayNode jsonNode = this.mapper.createArrayNode();
        if (CollectionUtils.isNotEmpty(industryWordResponseList)) {
            for (IndustryWordResponse industryWordResponse : industryWordResponseList) {
                ObjectNode wordNode = this.mapper.createObjectNode();
                wordNode.put("data_name", industryWordResponse.getDataName());
                wordNode.put("description_zh_cn", industryWordResponse.getDescriptionZhCn());
                wordNode.put("industry_no", industryWordResponse.getIndustryNo());
                wordNode.put("industry_name", industryWordResponse.getIndustryName());
                wordNode.put("industry_term_zh_cn", industryWordResponse.getIndustryTermZhCn());
                wordNode.put("data_type", industryWordResponse.getDataType());
                wordNode.put("size", industryWordResponse.getSize());
                wordNode.put("field_precision", industryWordResponse.getFieldPrecision());
                jsonNode.add((JsonNode)wordNode);
            }
        }
        tDataNode.set("data", (JsonNode)jsonNode);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

