/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CloudMappingSettingUpdateService
extends AbstractApiService {
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;
    @Autowired
    private ProductDao productDao;
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private PrdDatakeyMappingDao prdDatakeyMappingDao;

    public CloudMappingSettingUpdateService() {
        this.jsonSchemaFileName = "cloud_mapping_setting_update_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws Exception {
        JsonNode requestNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + requestNode));
        String action = requestNode.get("action").asText();
        String eocSetting = requestNode.get("eoc_setting").asText();
        String tenantId = requestNode.get("tenant_id").asText();
        String prodName = requestNode.get("prod_name").asText();
        String uid = requestNode.get("uid").asText();
        ArrayNode mappingInfoArrayNode = (ArrayNode)requestNode.get("mapping_info");
        if ("Update".equalsIgnoreCase(action)) {
            HashMap<String, String> queryCondition = new HashMap<String, String>();
            queryCondition.put("tenant_id", tenantId);
            queryCondition.put("eoc_level", "cloud_mapping_id");
            queryCondition.put("uid", uid);
            queryCondition.put("prod_name", prodName);
            List<EocIntgMapping> tMappings = this.eocIntgMappingDao.fetch(queryCondition);
            Map<String, EocIntgMapping> eocIntgMappingMap = tMappings.stream().collect(Collectors.toMap(x -> x.getEocId().concat("_").concat(x.getIntgId()).concat("_").concat(x.getCloudMappingType()), x -> x));
            mappingInfoArrayNode.forEach(mappingInfo -> {
                String key = mappingInfo.get("eoc_id").asText().concat("_").concat(mappingInfo.get("intg_id").asText()).concat("_").concat(mappingInfo.get("type").asText());
                if (ObjectUtils.allNotNull((Object[])new Object[]{mappingInfo.get("eoc_id"), mappingInfo.get("intg_id")}) && eocIntgMappingMap.get(key) == null) {
                    EocIntgMapping eocIntgMapping = new EocIntgMapping();
                    eocIntgMapping.setEocLevel("cloud_mapping_id");
                    eocIntgMapping.setTenantId(tenantId);
                    eocIntgMapping.setProducName(prodName);
                    eocIntgMapping.setProductUid(uid);
                    eocIntgMapping.setEocId(mappingInfo.get("eoc_id").asText());
                    eocIntgMapping.setIntgId(mappingInfo.get("intg_id").asText());
                    eocIntgMapping.setCloudMappingType(mappingInfo.get("type").asText());
                    eocIntgMapping.setBuildTime(Calendar.getInstance());
                    HashMap<String, String> tPrdDatakeyMappingCondition = new HashMap<String, String>();
                    tPrdDatakeyMappingCondition.put("prod_name", prodName);
                    tPrdDatakeyMappingCondition.put("eoc_level", eocIntgMapping.getCloudMappingType());
                    List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
                    if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
                        eocIntgMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
                    }
                    this.eocIntgMappingDao.save(eocIntgMapping);
                }
            });
            HashMap<String, String> tProductCondition = new HashMap<String, String>();
            tProductCondition.put("uid", uid);
            List<Product> tProducts = this.productDao.fetch(tProductCondition);
            if (CollectionUtils.isNotEmpty(tProducts)) {
                Map<String, Product> productMap = tProducts.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getTenantId())).collect(Collectors.toMap(Product::getTenantId, x -> x));
                if (Objects.nonNull(productMap.get(tenantId))) {
                    Product product = productMap.get(tenantId);
                    if (eocSetting != null) {
                        product.setEocSetting(eocSetting);
                    }
                    product.setLastUpdateTime(Calendar.getInstance());
                    this.productDao.save(product);
                } else {
                    Map<String, Product> productMapByTenantIdIsNull = tProducts.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getTenantId())).collect(Collectors.toMap(Product::getEaiUid, x -> x));
                    HashMap<String, String> tCondition = new HashMap<String, String>();
                    tCondition.put("tenant", tenantId);
                    List<EaiTenantMapping> eaiTenantMappings = this.eaiTenantMappingDao.fetch(tCondition);
                    if (CollectionUtils.isNotEmpty(eaiTenantMappings) && Objects.nonNull(productMapByTenantIdIsNull.get(eaiTenantMappings.get(0).getEaUid()))) {
                        Product product = productMapByTenantIdIsNull.get(eaiTenantMappings.get(0).getEaUid());
                        if (eocSetting != null) {
                            product.setEocSetting(eocSetting);
                        }
                        product.setTenantId(tenantId);
                        product.setLastUpdateTime(Calendar.getInstance());
                        this.productDao.save(product);
                    } else {
                        Map<String, Product> productMapByEaiUid = tProducts.stream().collect(Collectors.toMap(Product::getEaiUid, x -> x));
                        if (CollectionUtils.isNotEmpty(eaiTenantMappings) && Objects.nonNull(productMapByEaiUid.get(eaiTenantMappings.get(0).getEaUid()))) {
                            Product product = productMapByEaiUid.get(eaiTenantMappings.get(0).getEaUid());
                            List<com.digiwin.metadatacache.model.Service> tServices = this.serviceDao.getByPrdId(product.getId());
                            if (eocSetting != null) {
                                product.setEocSetting(eocSetting);
                            }
                            product.setBuildTime(Calendar.getInstance());
                            product.setTenantId(tenantId);
                            product.setId(null);
                            Product tReturnedProduct = this.productDao.save(product);
                            for (com.digiwin.metadatacache.model.Service service : tServices) {
                                service.setProduct(tReturnedProduct);
                                service.setId(null);
                                this.serviceDao.save(service);
                            }
                        }
                    }
                }
            }
        } else if ("delete".equalsIgnoreCase(action)) {
            mappingInfoArrayNode.forEach(mappingInfo -> {
                String eocId = mappingInfo.get("eoc_id").asText();
                String intGId = mappingInfo.get("intg_id").asText();
                String type = mappingInfo.get("type").asText();
                String level = mappingInfo.get("level").asText();
                this.eocIntgMappingDao.deleteCloudMapping(tenantId, level, type, uid, prodName, eocId, intGId);
            });
            HashMap<String, String> tCondition = new HashMap<String, String>();
            tCondition.put("tenant", tenantId);
            if (uid != null && !StringUtil.isEmptyOrSpace(uid)) {
                tCondition.put("uid", uid);
            }
            List<Product> tProducts = this.productDao.fetch(tCondition);
            HashMap<String, String> tMappingCondition = new HashMap<String, String>();
            tMappingCondition.put("product_uid", uid);
            tMappingCondition.put("tenant_id", tenantId);
            tMappingCondition.put("eoc_level", "cloud_mapping_id");
            List<EocIntgMapping> tEocIntgMappings = this.eocIntgMappingDao.fetch(tMappingCondition);
            if (CollectionUtils.isNotEmpty(tProducts) && tEocIntgMappings.isEmpty()) {
                tProducts.get(0).setTenantId("");
                this.productDao.save(tProducts.get(0));
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

