/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.TenantEocSetInfoDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.TenantEocSetInfo;
import com.digiwin.metadatacache.util.CacVerifyServiceUtil;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EocSetInfoCheckService
extends AbstractApiService {
    @Autowired
    private TenantEocSetInfoDao tenantEocSetInfoDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private ProductDao productDao;

    public EocSetInfoCheckService() {
        this.jsonSchemaFileName = "eoc_set_info_check_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        return this.checkEocSetInfo(tRequestJsonNode);
    }

    private Map<String, Object> checkEocSetInfo(JsonNode pMessageNode) throws Exception {
        HashMap<String, Object> tReturn = new HashMap<String, Object>();
        String tToken = DWServiceContext.getContext().getRequestHeader().get("token").toString();
        String tAction = null;
        if (pMessageNode.get("action") != null) {
            tAction = pMessageNode.get("action").asText();
        }
        String tenantId = pMessageNode.get("tenant_id").asText();
        String userId = pMessageNode.get("user_id").asText();
        if (tAction != null && tAction.equals("delete")) {
            this.tenantEocSetInfoDao.deleteIgnoreSetting(tenantId);
            tReturn.put("result", "delete tenantId " + tenantId + " ignore setting success.");
        } else {
            List<String> productIds = CacVerifyServiceUtil.getEnabledModules(tenantId, tToken);
            if (CollectionUtils.isEmpty(productIds)) {
                tReturn.put("remindUnitSetting", false);
            } else {
                boolean judge = true;
                for (String appId : productIds) {
                    this.log.info((Object)("cac\u83b7\u53d6\u7684\u4ea7\u54c1appId\uff1a" + appId));
                    List<Product> productList = this.productDao.queryByAppId(appId);
                    this.log.info((Object)("cac\u83b7\u53d6\u7684\u4ea7\u54c1appId\u5bf9\u5e94\u7684\u4ea7\u54c1\u5217\u8868\uff1a" + productList));
                    if (!CollectionUtils.isEmpty(productList) && (!CollectionUtils.isNotEmpty(productList) || !productList.stream().anyMatch(x -> x.getSettingEocFlag() == 0))) continue;
                    judge = false;
                    break;
                }
                if (judge) {
                    tReturn.put("remindUnitSetting", false);
                } else {
                    HashMap<String, String> condition = new HashMap<String, String>();
                    condition.put("tenant_id", tenantId);
                    List<TenantEocSetInfo> tenantEocSetInfos = this.tenantEocSetInfoDao.fetch(condition);
                    if (CollectionUtils.isNotEmpty(tenantEocSetInfos)) {
                        tReturn.put("remindUnitSetting", false);
                    } else {
                        boolean remindUnitSetting = true;
                        String version = IamVerifyServiceUtil.getCurrentTenantVersion(tenantId);
                        if ("v1".equalsIgnoreCase(version)) {
                            HashMap<String, String> eocCondition = new HashMap<String, String>();
                            eocCondition.put("tenant_id", tenantId);
                            List<EocIntgMapping> eocIntgMappings = this.eocIntgMappingDao.fetch(eocCondition);
                            if (CollectionUtils.isNotEmpty(eocIntgMappings)) {
                                for (EocIntgMapping mapping : eocIntgMappings) {
                                    if (!mapping.getEocLevel().equals("company_id") && !mapping.getEocLevel().equals("site_id")) continue;
                                    remindUnitSetting = false;
                                    break;
                                }
                            }
                        } else {
                            HashMap<String, String> eocCondition = new HashMap<String, String>();
                            eocCondition.put("tenant_id", tenantId);
                            eocCondition.put("eoc_level", "cloud_mapping_id");
                            List<EocIntgMapping> eocIntgMappings = this.eocIntgMappingDao.fetch(eocCondition);
                            if (CollectionUtils.isNotEmpty(eocIntgMappings)) {
                                for (EocIntgMapping mapping : eocIntgMappings) {
                                    if (!mapping.getCloudMappingType().equals("company_id") && !mapping.getCloudMappingType().equals("site_id")) continue;
                                    remindUnitSetting = false;
                                    break;
                                }
                            }
                        }
                        if (remindUnitSetting && IamVerifyServiceUtil.isPersonalTenant(tToken)) {
                            remindUnitSetting = false;
                        }
                        tReturn.put("remindUnitSetting", remindUnitSetting);
                    }
                }
            }
            tReturn.put("userRole", IamVerifyServiceUtil.isSuperAdmin(userId, tToken) ? "super" : "common");
        }
        return tReturn;
    }
}

