/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.GlobalParamsDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.GlobalParam;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GlobalParamsGetService
extends AbstractApiService {
    @Autowired
    private GlobalParamsDao globalParamsDao;

    public GlobalParamsGetService() {
        this.jsonSchemaFileName = "global_params_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tCacheMapKey = CacheMapTypeEnum.global_param_cachemap.getCode();
        String tDataFromCache = this.cacheService.getCacheMapValue(tCacheMapKey, tTenantId);
        if (null != tDataFromCache) {
            this.log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + tCacheMapKey + "// " + tTenantId));
            return this.converJsonStringToMap(tDataFromCache);
        }
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", tTenantId);
        List<GlobalParam> tGlobalParamsList = this.globalParamsDao.fetch(pCondition);
        ObjectNode tMgmtParamsNode = this.mapper.createObjectNode();
        if (CollectionUtils.isNotEmpty(tGlobalParamsList)) {
            for (GlobalParam tGlobalParam : tGlobalParamsList) {
                tMgmtParamsNode.put(tGlobalParam.getParam(), tGlobalParam.getValue());
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.put("tenant_id", tTenantId);
        tResponseJsonNode.set("mgmt_params", (JsonNode)tMgmtParamsNode);
        if (tStateCode.getCode().equals("000") && CollectionUtils.isNotEmpty(tGlobalParamsList)) {
            this.cacheService.setCacheMapValue(tCacheMapKey, tTenantId, tResponseJsonNode.toString());
        }
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

