/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class IntgInfoGetService
extends AbstractApiService {
    public IntgInfoGetService() {
        this.jsonSchemaFileName = "intg_info_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tEntId = null;
        if (tRequestJsonNode.get("ent_id") != null) {
            tEntId = tRequestJsonNode.get("ent_id").asText();
        }
        String tProdName = tRequestJsonNode.get("prod_name").asText();
        String tUid = tRequestJsonNode.get("uid").asText();
        JsonNode tIntgNode = IntgInfoServiceUtil.getIntgInfo(tEntId, tTenantId, tProdName, tUid);
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, tIntgNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    @Override
    protected ObjectNode createResponseJsonNode(String pCode, String pDescription, JsonNode pIntgInfoNode) {
        ObjectNode tResponseJsonNode = this.mapper.createObjectNode();
        ObjectNode tExecutionNode = this.mapper.createObjectNode();
        tResponseJsonNode.set("execution", (JsonNode)tExecutionNode);
        tExecutionNode.put("code", pCode);
        if (!StringUtil.isEmptyOrSpace(pDescription)) {
            tExecutionNode.put("description", pDescription);
        }
        if (pIntgInfoNode != null) {
            tResponseJsonNode.set("intg_info", pIntgInfoNode);
        }
        return tResponseJsonNode;
    }
}

