/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperationManageSettingGetService
extends AbstractApiService {
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    public OperationManageSettingGetService() {
        this.jsonSchemaFileName = "operation_manage_setting_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tUid = null;
        String tEnterPriseId = null;
        if (tRequestJsonNode.get("enterprise_id") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("enterprise_id").asText())) {
            tEnterPriseId = tRequestJsonNode.get("enterprise_id").asText();
        }
        if (tRequestJsonNode.get("uid") != null && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get("uid").asText())) {
            tUid = tRequestJsonNode.get("uid").asText();
        }
        String tProdName = tRequestJsonNode.get("prod_name").asText();
        return this.getOperationManageSetting(tTenantId, tProdName, tUid, tEnterPriseId);
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getOperationManageSetting(String pTenantId, String pProdName, String pUid, String pEnterPriseId) throws Exception {
        void var14_21;
        ArrayList<EocIntgMapping> tEnterpriseIdMappings = new ArrayList<EocIntgMapping>();
        ArrayList<EocIntgMapping> tCompanyIdMappings = new ArrayList<EocIntgMapping>();
        ArrayList<EocIntgMapping> tSiteIdMappings = new ArrayList<EocIntgMapping>();
        ArrayList<EocIntgMapping> tRegionIdMappings = new ArrayList<EocIntgMapping>();
        HashMap<String, String> pCondition = new HashMap<String, String>();
        pCondition.put("tenant_id", pTenantId);
        pCondition.put("prod_name", pProdName);
        if (pUid != null) {
            pCondition.put("uid", pUid);
        }
        List<EocIntgMapping> tEocIntgMappings = this.eocIntgMappingDao.fetch(pCondition);
        for (EocIntgMapping eocIntgMapping : tEocIntgMappings) {
            if (eocIntgMapping.getEocLevel().equals(EocLevelEnum.company_id.toString())) {
                tCompanyIdMappings.add(eocIntgMapping);
                continue;
            }
            if (eocIntgMapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                tSiteIdMappings.add(eocIntgMapping);
                continue;
            }
            if (eocIntgMapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) {
                tRegionIdMappings.add(eocIntgMapping);
                continue;
            }
            if (!eocIntgMapping.getEocLevel().equals(EocLevelEnum.enterprise_id.toString())) continue;
            tEnterpriseIdMappings.add(eocIntgMapping);
        }
        ObjectNode tEnterpriseLevelMappingNode = this.mapper.createObjectNode();
        if (!tEnterpriseIdMappings.isEmpty()) {
            EocIntgMapping mapping = (EocIntgMapping)tEnterpriseIdMappings.get(0);
            tEnterpriseLevelMappingNode.put("eoc_enterprise_id", mapping.getEocId());
            tEnterpriseLevelMappingNode.put("om_enterprise_id", mapping.getIntgId());
            if (mapping.getDatakey() != null && mapping.getDatakey().length() != 0) {
                tEnterpriseLevelMappingNode.put("datakey", mapping.getDatakey());
            }
        }
        ArrayNode tOrgTypeCompanyArrayNode = this.mapper.createArrayNode();
        for (EocIntgMapping eocIntgMapping : tCompanyIdMappings) {
            ObjectNode tCompanyLevelMappingNode = this.mapper.createObjectNode();
            tCompanyLevelMappingNode.put("eoc_company_id", eocIntgMapping.getEocId());
            tCompanyLevelMappingNode.put("om_company_id", eocIntgMapping.getIntgId());
            tCompanyLevelMappingNode.put("eoc_company_name", eocIntgMapping.getEocName());
            tCompanyLevelMappingNode.put("om_company_name", eocIntgMapping.getIntgName());
            if (eocIntgMapping.getDatakey() != null && eocIntgMapping.getDatakey().length() != 0) {
                tCompanyLevelMappingNode.put("datakey", eocIntgMapping.getDatakey());
            }
            tOrgTypeCompanyArrayNode.add((JsonNode)tCompanyLevelMappingNode);
            tCompanyLevelMappingNode.put("enable", true);
        }
        for (EocIntgMapping eocIntgMapping : tSiteIdMappings) {
            ObjectNode tSiteLevelMappingNode = this.mapper.createObjectNode();
            tSiteLevelMappingNode.put("eoc_site_id", eocIntgMapping.getEocId());
            tSiteLevelMappingNode.put("om_site_id", eocIntgMapping.getIntgId());
            tSiteLevelMappingNode.put("eoc_site_name", eocIntgMapping.getEocName());
            tSiteLevelMappingNode.put("om_site_name", eocIntgMapping.getIntgName());
            if (eocIntgMapping.getDatakey() != null && eocIntgMapping.getDatakey().length() != 0) {
                tSiteLevelMappingNode.put("datakey", eocIntgMapping.getDatakey());
            }
            tSiteLevelMappingNode.put("enable", true);
            if (eocIntgMapping.getEocIntgMapping() == null) continue;
            for (JsonNode tCompanyNode : tOrgTypeCompanyArrayNode) {
                if (!tCompanyNode.get("eoc_company_id").asText().equals(eocIntgMapping.getEocIntgMapping().getEocId())) continue;
                if (tCompanyNode.get("org_type_site") != null) {
                    ((ArrayNode)tCompanyNode.get("org_type_site")).add((JsonNode)tSiteLevelMappingNode);
                    continue;
                }
                ArrayNode tOrgTypeSiteArrayNode = this.mapper.createArrayNode();
                ((ObjectNode)tCompanyNode).set("org_type_site", (JsonNode)tOrgTypeSiteArrayNode);
                tOrgTypeSiteArrayNode.add((JsonNode)tSiteLevelMappingNode);
            }
        }
        ArrayNode tOrgTypeRegionArrayNode = this.mapper.createArrayNode();
        for (EocIntgMapping tRegionIdMapping : tRegionIdMappings) {
            ObjectNode tRegionLevelMappingNode = this.mapper.createObjectNode();
            tRegionLevelMappingNode.put("eoc_region_id", tRegionIdMapping.getEocId());
            tRegionLevelMappingNode.put("om_region_id", tRegionIdMapping.getIntgId());
            if (tRegionIdMapping.getRegionType() == null) {
                tRegionLevelMappingNode.put("region_type", "");
            } else {
                tRegionLevelMappingNode.put("region_type", tRegionIdMapping.getRegionType());
            }
            if (tRegionIdMapping.getDatakey() != null && tRegionIdMapping.getDatakey().length() != 0) {
                tRegionLevelMappingNode.put("datakey", tRegionIdMapping.getDatakey());
            }
            tRegionLevelMappingNode.put("enable", true);
            tOrgTypeRegionArrayNode.add((JsonNode)tRegionLevelMappingNode);
        }
        if (StringUtil.isEmpty(pEnterPriseId)) {
            if (tEnterpriseIdMappings.size() != 0) {
                JsonNode jsonNode = IntgInfoServiceUtil.getIntgInfo(((EocIntgMapping)tEnterpriseIdMappings.get(0)).getEocId(), pTenantId, pProdName, pUid);
            } else {
                JsonNode jsonNode = IntgInfoServiceUtil.getIntgInfo(null, pTenantId, pProdName, pUid);
            }
        } else {
            JsonNode jsonNode = IntgInfoServiceUtil.getIntgInfo(pEnterPriseId, pTenantId, pProdName, pUid);
        }
        ObjectNode tEocInfoNode = EocInfoServiceUtil.getEocInfoByUserToken(DWServiceContext.getContext().getRequestHeader().get("token").toString());
        ObjectNode tEocDataNode = (ObjectNode)tEocInfoNode.get("data");
        ArrayNode tEocCompanyAryNode = (ArrayNode)tEocDataNode.get("companies");
        ArrayNode tEocFactoriesAryNode = (ArrayNode)tEocDataNode.get("factories");
        ArrayNode tIntgCompanyAryNode = (ArrayNode)var14_21.get("org_type_company");
        for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
            boolean isEnable = false;
            JsonNode enableCompanyNode = null;
            for (Object tCompanyNode : tOrgTypeCompanyArrayNode) {
                if (!tIntgCompanyObject.get("company_no").asText().equals(tCompanyNode.get("om_company_id").asText())) continue;
                isEnable = true;
                enableCompanyNode = tCompanyNode;
                break;
            }
            ObjectNode tAddCompanyMappingNode = this.mapper.createObjectNode();
            if (!isEnable) {
                Object tCompanyNode;
                tAddCompanyMappingNode.put("eoc_company_id", tIntgCompanyObject.get("company_no").asText());
                tAddCompanyMappingNode.put("om_company_id", tIntgCompanyObject.get("company_no").asText());
                tAddCompanyMappingNode.put("om_company_name", tIntgCompanyObject.get("company_name").asText());
                tCompanyNode = tEocCompanyAryNode.iterator();
                while (tCompanyNode.hasNext()) {
                    JsonNode tEocCompanyObject = (JsonNode)tCompanyNode.next();
                    if (!tEocCompanyObject.get("id").asText().equals(tIntgCompanyObject.get("company_no").asText())) continue;
                    tAddCompanyMappingNode.put("eoc_company_name", tEocCompanyObject.get("name").asText());
                }
                tAddCompanyMappingNode.put("enable", false);
                tOrgTypeCompanyArrayNode.add((JsonNode)tAddCompanyMappingNode);
            }
            if (tIntgCompanyObject.get("org_type_site") == null) continue;
            ArrayNode tOrgTypeSiteAryNodeUnderCompany = (ArrayNode)tIntgCompanyObject.get("org_type_site");
            if (!isEnable) {
                ArrayNode tAddSiteAryNode = this.mapper.createArrayNode();
                for (JsonNode tSiteNode : tOrgTypeSiteAryNodeUnderCompany) {
                    ObjectNode tAddSiteMappingNode = this.mapper.createObjectNode();
                    tAddSiteMappingNode.put("eoc_site_id", tSiteNode.get("site_no").asText());
                    tAddSiteMappingNode.put("om_site_id", tSiteNode.get("site_no").asText());
                    for (JsonNode tEocSiteObject : tEocFactoriesAryNode) {
                        if (tEocSiteObject.get("companyId") == null || !tEocSiteObject.get("companyId").asText().equals(tIntgCompanyObject.get("company_no").asText()) || !tEocSiteObject.get("id").asText().equals(tSiteNode.get("site_no").asText())) continue;
                        tAddSiteMappingNode.put("eoc_site_name", tEocSiteObject.get("name").asText());
                    }
                    tAddSiteMappingNode.put("om_site_name", tSiteNode.get("site_name").asText());
                    tAddSiteMappingNode.put("enable", false);
                    tAddSiteAryNode.add((JsonNode)tAddSiteMappingNode);
                }
                tAddCompanyMappingNode.put("org_type_site", (JsonNode)tAddSiteAryNode);
                continue;
            }
            ArrayNode tEnableSiteAryNode = (ArrayNode)enableCompanyNode.get("org_type_site");
            if (tEnableSiteAryNode == null) {
                tEnableSiteAryNode = this.mapper.createArrayNode();
            }
            for (JsonNode tSiteNode : tOrgTypeSiteAryNodeUnderCompany) {
                boolean isSiteEnable = false;
                for (JsonNode tEnableSiteNode : tEnableSiteAryNode) {
                    if (!tEnableSiteNode.get("om_site_id").asText().equals(tSiteNode.get("site_no").asText())) continue;
                    isSiteEnable = true;
                    break;
                }
                if (isSiteEnable) continue;
                ObjectNode tAddSiteMappingNode = this.mapper.createObjectNode();
                tAddSiteMappingNode.put("eoc_site_id", tSiteNode.get("site_no").asText());
                tAddSiteMappingNode.put("om_site_id", tSiteNode.get("site_no").asText());
                for (JsonNode tEocSiteObject : tEocFactoriesAryNode) {
                    if (tEocSiteObject.get("companyId") == null || !tEocSiteObject.get("companyId").asText().equals(tIntgCompanyObject.get("company_no").asText()) || !tEocSiteObject.get("id").asText().equals(tSiteNode.get("site_no").asText())) continue;
                    tAddSiteMappingNode.put("eoc_site_name", tEocSiteObject.get("name").asText());
                }
                tAddSiteMappingNode.put("om_site_name", tSiteNode.get("site_name").asText());
                tAddSiteMappingNode.put("enable", false);
                tEnableSiteAryNode.add((JsonNode)tAddSiteMappingNode);
            }
            ((ObjectNode)enableCompanyNode).set("org_type_site", (JsonNode)tEnableSiteAryNode);
        }
        StateCode tStateCode = this.getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("org_type_enterprise", (JsonNode)tEnterpriseLevelMappingNode);
        tResponseJsonNode.set("org_type_company", (JsonNode)tOrgTypeCompanyArrayNode);
        tResponseJsonNode.set("org_type_region", (JsonNode)tOrgTypeRegionArrayNode);
        tResponseJsonNode.put("tenant_id", pTenantId);
        tResponseJsonNode.put("prod_name", pProdName);
        tResponseJsonNode.put("uid", pUid);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

