/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.apiservice.request.TenantApiProductListGetRequest;
import com.digiwin.metadatacache.apiservice.response.TenantApiProductListGetResponse;
import com.digiwin.metadatacache.dao.ApiDao;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.ApiRelation;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.services.MdcProductService;
import com.digiwin.metadatacache.util.JsonUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantApiProductListGetService
extends AbstractApiService {
    @Autowired
    private ApiDao apiDao;
    @Autowired
    private ApiVersionDao apiVersionDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private MdcProductService productService;
    @Autowired
    private EaiTenantMappingDao eaiTenantMappingDao;

    public TenantApiProductListGetService() {
        this.jsonSchemaFileName = "tenant_api_prd_list_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        Map<String, List<Product>> dbProductMap;
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        TenantApiProductListGetRequest request = JsonUtil.toJavaObj(tRequestJsonNode, TenantApiProductListGetRequest.class);
        String tenantId = request.getTenantId();
        List<String> apiNames = request.getApiNames();
        List<ApiRelation> apiRelations = this.apiRelationDao.getRelationBySub(apiNames, tenantId);
        HashMap<String, String> apiRelationMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(apiRelations)) {
            apiRelations.forEach(one -> {
                if (StringUtils.isEmpty((String)one.getSubTenantId())) {
                    apiRelationMap.putIfAbsent(one.getSubApiName(), one.getParentApiName());
                } else {
                    apiRelationMap.put(one.getSubApiName(), one.getParentApiName());
                }
            });
        }
        Map<String, List<Product>> productMap = this.getProductFromCache(tenantId, apiNames, apiRelationMap);
        List<String> notFoundProdApis = apiNames.stream().filter(api -> !productMap.containsKey(api)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(notFoundProdApis) && MapUtils.isNotEmpty(dbProductMap = this.productService.getProductFromDb(tenantId, notFoundProdApis, apiRelationMap))) {
            productMap.putAll(dbProductMap);
        }
        Map<String, List<TenantApiProductListGetResponse.ProductVO>> productVOMap = productMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> TenantApiProductListGetService.covertToProductVO((List)entry.getValue())));
        TenantApiProductListGetResponse response = new TenantApiProductListGetResponse(tenantId, productVOMap);
        String tDescription = this.getDescriptionByLocale(SUCCESS_STATE, this.locale);
        return this.createResponseMap(SUCCESS_STATE.getCode(), tDescription, response.toMap());
    }

    private Map<String, List<Product>> getProductFromCache(String tenantId, List<String> apiNames, Map<String, String> apiRelationMap) {
        String tStandardKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + tenantId;
        Map standardCache = (Map)this.cacheService.get(tStandardKey);
        HashMap<String, List<Product>> productMap = new HashMap<String, List<Product>>();
        apiNames.forEach(api -> {
            String realApi = apiRelationMap.containsKey(api) ? (String)apiRelationMap.get(api) : api;
            List<Product> products = this.productService.getStandardProductCache(tenantId, standardCache, realApi);
            if (CollectionUtils.isEmpty(products)) {
                products = this.productService.getAgileProductCache(tenantId, realApi);
                if (CollectionUtils.isNotEmpty(products)) {
                    productMap.put(realApi, products);
                }
            } else {
                this.log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + tStandardKey));
                productMap.put(realApi, products);
            }
        });
        return productMap;
    }

    private static List<TenantApiProductListGetResponse.ProductVO> covertToProductVO(List<Product> products) {
        if (null == products) {
            return null;
        }
        return products.stream().map(product -> {
            TenantApiProductListGetResponse.ProductVO vo = new TenantApiProductListGetResponse.ProductVO();
            vo.setVersion(product.getVersion());
            vo.setUid(product.getUid());
            vo.setId(product.getApid());
            vo.setIp(product.getIp());
            vo.setName(product.getName());
            vo.setGatewayId(product.getGatewayId());
            return vo;
        }).collect(Collectors.toList());
    }
}

