/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.apiservice.AbstractApiService;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantProductInfoGetService
extends AbstractApiService {
    @Autowired
    private ProductDao productDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private PrdDatakeyMappingDao prdDatakeyMappingDao;

    public TenantProductInfoGetService() {
        this.jsonSchemaFileName = "tenant_prd_info_get_schema.json";
    }

    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        this.log.info((Object)("[Thread.id " + Thread.currentThread().getId() + "]\u63a5\u53e3: " + this.getClass() + ", \u539f\u59cb\u8a0a\u606f: " + tRequestJsonNode));
        String tTenantId = tRequestJsonNode.get("tenant_id").asText();
        String tProdName = tRequestJsonNode.get("prod_name").asText();
        String version = IamVerifyServiceUtil.getCurrentTenantVersion(tTenantId);
        if ("v1".equalsIgnoreCase(version)) {
            return this.getTenantProductInfo(validatorResult, tTenantId, tProdName);
        }
        return this.getTenantProductInfoV2(validatorResult, tTenantId, tProdName);
    }

    private Map<String, Object> getTenantProductInfo(ValidatorResult validatorResult, String tTenantId, String tProdName) throws IOException {
        ObjectNode tDataNode = this.mapper.createObjectNode();
        String tCacheMapKey = CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + ":" + tTenantId;
        String tDataFromCache = this.cacheService.getCacheMapValue(tCacheMapKey, tProdName);
        if (null != tDataFromCache) {
            this.log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + tCacheMapKey + "// " + tProdName));
            return this.converJsonStringToMap(tDataFromCache);
        }
        HashMap<String, String> tProductCondition = new HashMap<String, String>();
        tProductCondition.put("name", tProdName);
        List<Product> tProducts = this.productDao.fetch(tProductCondition);
        if (!tProducts.isEmpty()) {
            if (tProducts.get(0).getProductType().equals(ApiTypeEnum.agile.toString())) {
                tDataNode = (ObjectNode)this.mapper.readTree("{ \"tenant_id\": \"" + tTenantId + "\", \"is_enterprise\": true, \"dispatch\": [ { \"service_product\": { \"name\": \"" + tProducts.get(0).getName() + "\", \"uid\": \"\" } } ] }");
            } else {
                HashMap<String, String> pEocIntgMapCondition = new HashMap<String, String>();
                pEocIntgMapCondition.put("tenant_id", tTenantId);
                pEocIntgMapCondition.put("product_name", tProdName);
                List<EocIntgMapping> eocIntgMappings = this.eocIntgMappingDao.fetch(pEocIntgMapCondition);
                Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = this.groupEocMappingByTenantAndProdNameAndUid(eocIntgMappings, tTenantId);
                tDataNode.put("tenant_id", tTenantId);
                boolean isEnterprise = false;
                ArrayNode tDispatchAryNode = this.mapper.createArrayNode();
                tDataNode.set("dispatch", (JsonNode)tDispatchAryNode);
                int dispatchLevel = 0;
                HashMap<String, String> tCondition = new HashMap<String, String>();
                tCondition.put("prod_name", tProdName);
                List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tCondition);
                if (CollectionUtils.isNotEmpty(tDatakeyMappings)) {
                    for (PrdDatakeyMapping tDatakeyMapping : tDatakeyMappings) {
                        if (tDatakeyMapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                            dispatchLevel = 1;
                            continue;
                        }
                        if (!tDatakeyMapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) continue;
                        dispatchLevel = 2;
                    }
                }
                if (!eocIntgMappings.isEmpty() && tTotalMap.get(tTenantId).get(tProdName) != null) {
                    for (String key : tTotalMap.get(tTenantId).get(tProdName).keySet()) {
                        boolean tMappingsNoDatakeyValue = true;
                        for (EocIntgMapping mapping : tTotalMap.get(tTenantId).get(tProdName).get(key)) {
                            if (mapping.getEocLevel().equals("enterprise_id") && !StringUtil.isEmptyOrSpace(mapping.getEocId())) {
                                isEnterprise = true;
                            }
                            ObjectNode tDispatchItemNode = this.mapper.createObjectNode();
                            if (StringUtil.isEmptyOrSpace(mapping.getDatakey())) continue;
                            ObjectNode tServiceProductNode = this.mapper.createObjectNode();
                            tDispatchItemNode.set("service_product", (JsonNode)tServiceProductNode);
                            tServiceProductNode.put("name", mapping.getProducName());
                            tServiceProductNode.put("uid", mapping.getProductUid());
                            ObjectNode tOperationManagerNode = this.mapper.createObjectNode();
                            if (mapping.getEocLevel().equals(EocLevelEnum.company_id.toString()) && dispatchLevel == 0) {
                                tDispatchAryNode.add((JsonNode)tDispatchItemNode);
                                tOperationManagerNode.put("eoc_company_id", mapping.getEocId());
                            } else if (mapping.getEocLevel().equals(EocLevelEnum.site_id.toString()) && dispatchLevel == 1) {
                                tDispatchAryNode.add((JsonNode)tDispatchItemNode);
                                if (mapping.getEocIntgMapping() != null) {
                                    tOperationManagerNode.put("eoc_company_id", mapping.getEocIntgMapping().getEocId());
                                }
                                tOperationManagerNode.put("eoc_site_id", mapping.getEocId());
                            } else if (mapping.getEocLevel().equals(EocLevelEnum.region_id.toString()) && dispatchLevel == 2) {
                                tDispatchAryNode.add((JsonNode)tDispatchItemNode);
                                if (mapping.getEocIntgMapping() != null) {
                                    if (mapping.getEocIntgMapping().getEocIntgMapping() != null) {
                                        tOperationManagerNode.put("eoc_company_id", mapping.getEocIntgMapping().getEocIntgMapping().getEocId());
                                    }
                                    tOperationManagerNode.put("eoc_site_id", mapping.getEocIntgMapping().getEocId());
                                }
                                tOperationManagerNode.put("eoc_region_id", mapping.getEocId());
                            }
                            tDispatchItemNode.set("operation_manager", (JsonNode)tOperationManagerNode);
                            tMappingsNoDatakeyValue = false;
                        }
                        if (!tMappingsNoDatakeyValue) continue;
                        ObjectNode tDispatchItemNode = this.mapper.createObjectNode();
                        ObjectNode tServiceProductNode = this.mapper.createObjectNode();
                        tDispatchItemNode.set("service_product", (JsonNode)tServiceProductNode);
                        tServiceProductNode.put("name", tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProducName());
                        tServiceProductNode.put("uid", tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProductUid());
                        tDispatchAryNode.add((JsonNode)tDispatchItemNode);
                    }
                }
                tDataNode.put("is_enterprise", isEnterprise);
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        if (tStateCode.getCode().equals("000") && null != tResponseJsonNode.get("data") && null != tResponseJsonNode.get("data").get("dispatch") && tResponseJsonNode.get("data").get("dispatch").size() > 0) {
            this.cacheService.setCacheMapValue(tCacheMapKey, tProdName, tResponseJsonNode.toString());
        }
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }

    private Map<String, Object> getTenantProductInfoV2(ValidatorResult validatorResult, String tTenantId, String tProdName) throws IOException {
        ObjectNode tDataNode = this.mapper.createObjectNode();
        HashMap<String, String> tProductCondition = new HashMap<String, String>();
        tProductCondition.put("name", tProdName);
        List<Product> tProducts = this.productDao.fetch(tProductCondition);
        if (!tProducts.isEmpty()) {
            if (tProducts.get(0).getProductType().equals(ApiTypeEnum.agile.toString())) {
                tDataNode = (ObjectNode)this.mapper.readTree("{ \"tenant_id\": \"" + tTenantId + "\", \"is_enterprise\": true, \"dispatch\": [ { \"service_product\": { \"name\": \"" + tProducts.get(0).getName() + "\", \"uid\": \"\" } } ] }");
            } else {
                HashMap<String, String> pEocIntgMapCondition = new HashMap<String, String>();
                pEocIntgMapCondition.put("tenant_id", tTenantId);
                pEocIntgMapCondition.put("product_name", tProdName);
                pEocIntgMapCondition.put("eoc_level", "cloud_mapping_id");
                List<EocIntgMapping> eocIntgMappings = this.eocIntgMappingDao.fetchGroupByEocId(pEocIntgMapCondition);
                Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = this.groupEocMappingByTenantAndProdNameAndUid(eocIntgMappings, tTenantId);
                tDataNode.put("tenant_id", tTenantId);
                boolean isEnterprise = false;
                ArrayNode tDispatchAryNode = this.mapper.createArrayNode();
                tDataNode.set("dispatch", (JsonNode)tDispatchAryNode);
                int dispatchLevel = 0;
                HashMap<String, String> tCondition = new HashMap<String, String>();
                tCondition.put("prod_name", tProdName);
                List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tCondition);
                if (CollectionUtils.isNotEmpty(tDatakeyMappings)) {
                    for (PrdDatakeyMapping tDatakeyMapping : tDatakeyMappings) {
                        if (tDatakeyMapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                            dispatchLevel = 1;
                            continue;
                        }
                        if (!tDatakeyMapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) continue;
                        dispatchLevel = 2;
                    }
                }
                if (!eocIntgMappings.isEmpty() && tTotalMap.get(tTenantId).get(tProdName) != null) {
                    for (String key : tTotalMap.get(tTenantId).get(tProdName).keySet()) {
                        boolean tMappingsNoDatakeyValue = true;
                        for (EocIntgMapping mapping : tTotalMap.get(tTenantId).get(tProdName).get(key)) {
                            if (mapping.getCloudMappingType().equals("enterprise_id") && !StringUtil.isEmptyOrSpace(mapping.getEocId())) {
                                isEnterprise = true;
                            }
                            ObjectNode tDispatchItemNode = this.mapper.createObjectNode();
                            if (StringUtil.isEmptyOrSpace(mapping.getDatakey())) continue;
                            ObjectNode tServiceProductNode = this.mapper.createObjectNode();
                            tDispatchItemNode.set("service_product", (JsonNode)tServiceProductNode);
                            tServiceProductNode.put("name", mapping.getProducName());
                            tServiceProductNode.put("uid", mapping.getProductUid());
                            ObjectNode tOperationManagerNode = this.mapper.createObjectNode();
                            if (mapping.getCloudMappingType().equals(EocLevelEnum.company_id.toString()) && dispatchLevel == 0) {
                                tDispatchAryNode.add((JsonNode)tDispatchItemNode);
                                tOperationManagerNode.put("eoc_mapping_id", mapping.getEocId());
                            } else if (mapping.getCloudMappingType().equals(EocLevelEnum.site_id.toString()) && dispatchLevel == 1) {
                                tDispatchAryNode.add((JsonNode)tDispatchItemNode);
                                tOperationManagerNode.put("eoc_mapping_id", mapping.getEocId());
                            } else if (mapping.getCloudMappingType().equals(EocLevelEnum.region_id.toString()) && dispatchLevel == 2) {
                                tDispatchAryNode.add((JsonNode)tDispatchItemNode);
                                tOperationManagerNode.put("eoc_mapping_id", mapping.getEocId());
                            }
                            tDispatchItemNode.set("operation_manager", (JsonNode)tOperationManagerNode);
                            tMappingsNoDatakeyValue = false;
                        }
                        if (!tMappingsNoDatakeyValue) continue;
                        ObjectNode tDispatchItemNode = this.mapper.createObjectNode();
                        ObjectNode tServiceProductNode = this.mapper.createObjectNode();
                        tDispatchItemNode.set("service_product", (JsonNode)tServiceProductNode);
                        tServiceProductNode.put("name", tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProducName());
                        tServiceProductNode.put("uid", tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProductUid());
                        tDispatchAryNode.add((JsonNode)tDispatchItemNode);
                    }
                }
                tDataNode.put("is_enterprise", isEnterprise);
            }
        }
        StateCode tStateCode = this.getStateCode(validatorResult.getState().getCode());
        String tDescription = this.getDescriptionByLocale(tStateCode, this.locale);
        ObjectNode tResponseJsonNode = this.createResponseJsonNode(tStateCode.getCode(), tDescription, (JsonNode)tDataNode);
        return this.converJsonNodeToMap((JsonNode)tResponseJsonNode);
    }
}

