/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.ApiRelationDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import com.digiwin.metadatacache.model.ApiRelation;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="mdcTransactionManager")
public class ApiRelationDaoImpl
extends GenericDaoImpl<ApiRelation, Long>
implements ApiRelationDao {
    public ApiRelationDaoImpl() {
        super(ApiRelation.class);
    }

    @Override
    public List<ApiRelation> getRelationBySub(String apiName, String tenantId) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(ApiRelation.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"subApiName", (Object)apiName));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"deleteFlag", (Object)0));
        Disjunction disjunction = Restrictions.disjunction();
        disjunction.add((Criterion)Restrictions.eq((String)"subTenantId", (Object)tenantId));
        disjunction.add(Restrictions.isNull((String)"subTenantId"));
        tDetachedCriteria.add((Criterion)disjunction);
        return this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
    }

    @Override
    public List<ApiRelation> getRelationBySub(List<String> apiNames, String tenantId) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(ApiRelation.class);
        tDetachedCriteria.add(Restrictions.in((String)"subApiName", apiNames));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"deleteFlag", (Object)0));
        Disjunction disjunction = Restrictions.disjunction();
        disjunction.add((Criterion)Restrictions.eq((String)"subTenantId", (Object)tenantId));
        disjunction.add(Restrictions.isNull((String)"subTenantId"));
        tDetachedCriteria.add((Criterion)disjunction);
        return this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
    }

    @Override
    public ApiRelation getRelationBySubInfo(String subApiName, String subTenantId) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(ApiRelation.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"subApiName", (Object)subApiName));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"deleteFlag", (Object)0));
        if (null != subTenantId) {
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)"subTenantId", (Object)subTenantId));
            disjunction.add(Restrictions.isNull((String)"subTenantId"));
            tDetachedCriteria.add((Criterion)disjunction);
        } else {
            tDetachedCriteria.add(Restrictions.isNull((String)"subTenantId"));
        }
        List apiRelations = this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
        if (CollectionUtils.isNotEmpty((Collection)apiRelations)) {
            return (ApiRelation)apiRelations.get(0);
        }
        return null;
    }

    @Override
    public ApiRelation judgeIsSub(String apiName, String tenantId) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(ApiRelation.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"subApiName", (Object)apiName));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"deleteFlag", (Object)0));
        if (null != tenantId) {
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)"subTenantId", (Object)tenantId));
            disjunction.add(Restrictions.isNull((String)"subTenantId"));
            tDetachedCriteria.add((Criterion)disjunction);
        } else {
            tDetachedCriteria.add(Restrictions.isNull((String)"subTenantId"));
        }
        List apiRelations = this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
        if (CollectionUtils.isNotEmpty((Collection)apiRelations)) {
            return (ApiRelation)apiRelations.get(0);
        }
        return null;
    }

    @Override
    public ApiRelation judgeIsParent(String apiName, String tenantId) {
        List apiRelations;
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(ApiRelation.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"parentApiName", (Object)apiName));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"deleteFlag", (Object)0));
        if (null != tenantId) {
            tDetachedCriteria.add((Criterion)Restrictions.eq((String)"subTenantId", (Object)tenantId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(apiRelations = this.getHibernateTemplate().findByCriteria(tDetachedCriteria)))) {
            return (ApiRelation)apiRelations.get(0);
        }
        return null;
    }
}

