/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import com.digiwin.metadatacache.model.ApiVersion;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="mdcTransactionManager")
public class ApiVersionDaoImpl
extends GenericDaoImpl<ApiVersion, Long>
implements ApiVersionDao {
    public ApiVersionDaoImpl() {
        super(ApiVersion.class);
    }

    @Override
    public List<ApiVersion> getByApiId(final Long pId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ApiVersion>>(){

            public List<ApiVersion> doInHibernate(Session session) throws HibernateException {
                List list;
                Query tQuery = session.createQuery("from ApiVersion where api_id = :param ");
                tQuery.setParameter("param", (Object)pId);
                List tApiVersions = list = tQuery.list();
                if (list.size() == 0) {
                    return null;
                }
                return tApiVersions;
            }
        });
    }

    @Override
    public ApiVersion getByApiIdAndVer(Long pId, String pVer) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(ApiVersion.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"Api.id", (Object)pId));
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"version", (Object)pVer));
        List tApiVersions = this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
        if (tApiVersions.size() == 0) {
            return null;
        }
        return (ApiVersion)tApiVersions.get(0);
    }

    @Override
    public ApiVersion getByApiNameAndVer(String pApiName, String pVer) {
        String hql = "SELECT av FROM ApiVersion av JOIN av.Api a WHERE a.name = :pApiName AND av.version = :pVer";
        List results = (List)this.getHibernateTemplate().execute(session -> {
            Query query = session.createQuery(hql);
            query.setParameter("pApiName", (Object)pApiName);
            query.setParameter("pVer", (Object)pVer);
            return query.list();
        });
        if (results.isEmpty()) {
            return null;
        }
        return (ApiVersion)results.get(0);
    }

    @Override
    public ApiVersion getByApiNameTenantVer(String pApiName, String pTenant, String pVer) {
        if (pTenant != null) {
            String hql = "SELECT av FROM ApiVersion av JOIN av.Api a WHERE a.name = :pApiName AND a.tenantId = :pTenantId AND av.version = :pVer";
            List results = (List)this.getHibernateTemplate().execute(session -> {
                Query query = session.createQuery(hql);
                query.setParameter("pApiName", (Object)pApiName);
                query.setParameter("pTenantId", (Object)pTenant);
                query.setParameter("pVer", (Object)pVer);
                return query.list();
            });
            if (results.isEmpty()) {
                return null;
            }
            return (ApiVersion)results.get(0);
        }
        String hql = "SELECT av FROM ApiVersion av JOIN av.Api a WHERE a.name = :pApiName AND a.tenantId is null AND av.version = :pVer";
        List results = (List)this.getHibernateTemplate().execute(session -> {
            Query query = session.createQuery(hql);
            query.setParameter("pApiName", (Object)pApiName);
            query.setParameter("pVer", (Object)pVer);
            return query.list();
        });
        if (results.isEmpty()) {
            return null;
        }
        return (ApiVersion)results.get(0);
    }

    @Override
    public List<ApiVersion> getByApiNameAndTenantId(final String apiName, final String tenantId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ApiVersion>>(){

            public List<ApiVersion> doInHibernate(Session session) throws HibernateException {
                List list;
                List tApiVersions;
                StringBuilder tStrBuild = new StringBuilder();
                tStrBuild.append("SELECT ver FROM ApiVersion ver JOIN ver.Api a ");
                tStrBuild.append("WHERE a.name = :name ");
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    tStrBuild.append("AND a.tenantId = :tenantId");
                } else {
                    tStrBuild.append("AND a.tenantId is null");
                }
                Query tQuery = session.createQuery(tStrBuild.toString());
                tQuery.setParameter("name", (Object)apiName);
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    tQuery.setParameter("tenantId", (Object)tenantId);
                }
                if ((tApiVersions = (list = tQuery.list())).size() == 0) {
                    return null;
                }
                return tApiVersions;
            }
        });
    }

    @Override
    public List<ApiVersion> getBaseInfoByApiNameAndTenantId(final String apiName, final String tenantId) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ApiVersion>>(){

            public List<ApiVersion> doInHibernate(Session session) throws HibernateException {
                StringBuilder tStrBuild = new StringBuilder();
                tStrBuild.append("SELECT ver FROM ApiVersion ver JOIN ver.Api a ");
                tStrBuild.append("WHERE a.name = :name ");
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    tStrBuild.append("AND (a.tenantId = :tenantId OR a.tenantId is null)");
                } else {
                    tStrBuild.append("AND a.tenantId is null");
                }
                Query tQuery = session.createQuery(tStrBuild.toString());
                tQuery.setParameter("name", (Object)apiName);
                if (StringUtils.isNotBlank((CharSequence)tenantId)) {
                    tQuery.setParameter("tenantId", (Object)tenantId);
                }
                List list = tQuery.list();
                return list;
            }
        });
    }

    @Override
    public ApiVersion getLatestVerByApiId(long pId) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(ApiVersion.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"Api.id", (Object)pId));
        List tApiVersions = this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
        if (tApiVersions.size() == 0) {
            return null;
        }
        String tMaxVer = "0.0";
        ApiVersion tMaxApiVer = null;
        for (ApiVersion tApiVersion : tApiVersions) {
            String[] versionSplit = tApiVersion.getVersion().split("\\.");
            String[] maxVersionSplit = tMaxVer.split("\\.");
            String versionIntegar = versionSplit[0];
            String versionDecimal = versionSplit[1];
            String maxVersionIntegar = maxVersionSplit[0];
            String maxVersionDecimal = maxVersionSplit[1];
            if (Integer.parseInt(versionIntegar) > Integer.parseInt(maxVersionIntegar)) {
                tMaxVer = tApiVersion.getVersion();
                tMaxApiVer = tApiVersion;
                continue;
            }
            if (!Integer.valueOf(versionIntegar).equals(Integer.valueOf(maxVersionIntegar)) || Integer.parseInt(versionDecimal) <= Integer.parseInt(maxVersionDecimal)) continue;
            tMaxVer = tApiVersion.getVersion();
            tMaxApiVer = tApiVersion;
        }
        return tMaxApiVer;
    }

    @Override
    public List<ApiVersion> getApiInfo(final Calendar pBuildTime, final String pProvider) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<ApiVersion>>(){

            public List<ApiVersion> doInHibernate(Session session) throws HibernateException {
                List list;
                List tApiVersions;
                StringBuilder tStrBuild = new StringBuilder();
                tStrBuild.append("SELECT ver FROM ApiVersion ver JOIN ver.Api a ");
                tStrBuild.append("WHERE ver.buildTime > :time ");
                if (pProvider != null) {
                    tStrBuild.append("AND a.provider like :provider ");
                }
                Query tQuery = session.createQuery(tStrBuild.toString());
                tQuery.setParameter("time", (Object)pBuildTime);
                if (pProvider != null) {
                    tQuery.setParameter("provider", (Object)("%" + pProvider + "%"));
                }
                if ((tApiVersions = (list = tQuery.list())).size() == 0) {
                    return null;
                }
                return tApiVersions;
            }
        });
    }
}

