/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.dao.impl;

import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.impl.GenericDaoImpl;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.services.MdcCacheService;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(value="mdcTransactionManager")
public class ProductDaoImpl
extends GenericDaoImpl<Product, Long>
implements ProductDao {
    @Autowired
    private MdcCacheService cacheService;

    public ProductDaoImpl() {
        super(Product.class);
    }

    @Override
    public List<Product> fetch(final Map<String, String> pConditions) {
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<Product>>(){

            public List<Product> doInHibernate(Session pSession) throws HibernateException {
                Criteria tCriteria = pSession.createCriteria(Product.class);
                tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
                if (pConditions.containsKey("tenant")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"tenantId", pConditions.get("tenant")));
                }
                if (pConditions.containsKey("name")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"name", pConditions.get("name")));
                }
                if (pConditions.containsKey("version")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"version", pConditions.get("version")));
                }
                if (pConditions.containsKey("eai_uid")) {
                    if (pConditions.get("eai_uid") != null) {
                        tCriteria.add((Criterion)Restrictions.eq((String)"eaiUid", pConditions.get("eai_uid")));
                    } else {
                        tCriteria.add(Restrictions.isNull((String)"eaiUid"));
                    }
                }
                if (pConditions.containsKey("uid")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"uid", pConditions.get("uid")));
                }
                if (pConditions.containsKey("id")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"apid", pConditions.get("id")));
                }
                if (pConditions.containsKey("product_type")) {
                    tCriteria.add((Criterion)Restrictions.eq((String)"productType", pConditions.get("product_type")));
                }
                return tCriteria.list();
            }
        });
    }

    @Override
    public void updateList(List<String> tCurrentTenantIdList, List<Product> pList) {
        for (Product tProduct : pList) {
            this.saveOrupdate(tProduct);
            for (String tenantId : tCurrentTenantIdList) {
                this.cacheService.removeCacheMapValueContainsWord(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + ":" + tenantId, tProduct.getName());
            }
        }
    }

    @Override
    public List<Product> queryByAppId(String appId) {
        DetachedCriteria tDetachedCriteria = DetachedCriteria.forClass(Product.class);
        tDetachedCriteria.add((Criterion)Restrictions.eq((String)"appId", (Object)appId));
        return this.getHibernateTemplate().findByCriteria(tDetachedCriteria);
    }
}

