/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.dao.ProductApiDispatchInfoDao;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;
import com.digiwin.metadatacache.model.ProductApiDispatchInfo;
import com.digiwin.metadatacache.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DispatchService {
    @Autowired
    private ProductApiDispatchInfoDao productApiDispatchInfoDao;
    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;
    @Autowired
    private PrdDatakeyMappingDao prdDatakeyMappingDao;

    public boolean isCanDispatch(String tProdName, String tApiName) {
        HashMap<String, String> tProductApiDispatchCondition = new HashMap<String, String>();
        tProductApiDispatchCondition.put("prod_name", tProdName);
        tProductApiDispatchCondition.put("api_name", tApiName);
        List<ProductApiDispatchInfo> productApiDispatchInfos = this.productApiDispatchInfoDao.fetch(tProductApiDispatchCondition);
        return CollectionUtils.isNotEmpty(productApiDispatchInfos);
    }

    public List<Map<String, Object>> getDispatch(String tTenantId, String tProdName) {
        HashMap<String, String> pEocIntgMapCondition = new HashMap<String, String>();
        pEocIntgMapCondition.put("tenant_id", tTenantId);
        pEocIntgMapCondition.put("product_name", tProdName);
        List<EocIntgMapping> eocIntgMappings = this.eocIntgMappingDao.fetch(pEocIntgMapCondition);
        if (CollectionUtils.isEmpty(eocIntgMappings)) {
            return null;
        }
        Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = this.groupEocMappingByTenantAndProdNameAndUid(eocIntgMappings, tTenantId);
        int dispatchLevel = 0;
        HashMap<String, String> tCondition = new HashMap<String, String>();
        tCondition.put("prod_name", tProdName);
        List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tCondition);
        if (CollectionUtils.isNotEmpty(tDatakeyMappings)) {
            for (PrdDatakeyMapping tDatakeyMapping : tDatakeyMappings) {
                if (tDatakeyMapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                    dispatchLevel = 1;
                    continue;
                }
                if (!tDatakeyMapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) continue;
                dispatchLevel = 2;
            }
        }
        ArrayList<Map<String, Object>> tDispatchAryNode = new ArrayList<Map<String, Object>>();
        for (String key : tTotalMap.get(tTenantId).get(tProdName).keySet()) {
            boolean tMappingsNoDatakeyValue = true;
            for (EocIntgMapping mapping : tTotalMap.get(tTenantId).get(tProdName).get(key)) {
                HashMap tDispatchItemNode = new HashMap();
                if (StringUtil.isEmptyOrSpace(mapping.getDatakey())) continue;
                HashMap<String, String> tServiceProductNode = new HashMap<String, String>();
                tDispatchItemNode.put("service_product", tServiceProductNode);
                tServiceProductNode.put("name", mapping.getProducName());
                tServiceProductNode.put("uid", mapping.getProductUid());
                HashMap<String, String> tOperationManagerNode = new HashMap<String, String>();
                if (mapping.getEocLevel().equals(EocLevelEnum.company_id.toString()) && dispatchLevel == 0) {
                    tDispatchAryNode.add(tDispatchItemNode);
                    tOperationManagerNode.put("eoc_company_id", mapping.getEocId());
                } else if (mapping.getEocLevel().equals(EocLevelEnum.site_id.toString()) && dispatchLevel == 1) {
                    tDispatchAryNode.add(tDispatchItemNode);
                    if (mapping.getEocIntgMapping() != null) {
                        tOperationManagerNode.put("eoc_company_id", mapping.getEocIntgMapping().getEocId());
                    }
                    tOperationManagerNode.put("eoc_site_id", mapping.getEocId());
                } else if (mapping.getEocLevel().equals(EocLevelEnum.region_id.toString()) && dispatchLevel == 2) {
                    tDispatchAryNode.add(tDispatchItemNode);
                    if (mapping.getEocIntgMapping() != null) {
                        if (mapping.getEocIntgMapping().getEocIntgMapping() != null) {
                            tOperationManagerNode.put("eoc_company_id", mapping.getEocIntgMapping().getEocIntgMapping().getEocId());
                        }
                        tOperationManagerNode.put("eoc_site_id", mapping.getEocIntgMapping().getEocId());
                    }
                    tOperationManagerNode.put("eoc_region_id", mapping.getEocId());
                }
                tDispatchItemNode.put("operation_manager", tOperationManagerNode);
                tMappingsNoDatakeyValue = false;
            }
            if (!tMappingsNoDatakeyValue) continue;
            HashMap tDispatchItemNode = new HashMap();
            HashMap<String, String> tServiceProductNode = new HashMap<String, String>();
            tDispatchItemNode.put("service_product", tServiceProductNode);
            tServiceProductNode.put("name", tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProducName());
            tServiceProductNode.put("uid", tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProductUid());
            tDispatchAryNode.add(tDispatchItemNode);
        }
        return tDispatchAryNode;
    }

    public List<Map<String, Object>> getDispatchV2(String tTenantId, String tProdName) {
        HashMap<String, String> pEocIntgMapCondition = new HashMap<String, String>();
        pEocIntgMapCondition.put("tenant_id", tTenantId);
        pEocIntgMapCondition.put("product_name", tProdName);
        pEocIntgMapCondition.put("eoc_level", "cloud_mapping_id");
        List<EocIntgMapping> eocIntgMappings = this.eocIntgMappingDao.fetch(pEocIntgMapCondition);
        if (CollectionUtils.isEmpty(eocIntgMappings)) {
            return null;
        }
        Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = this.groupEocMappingByTenantAndProdNameAndUid(eocIntgMappings, tTenantId);
        int dispatchLevel = 0;
        HashMap<String, String> tCondition = new HashMap<String, String>();
        tCondition.put("prod_name", tProdName);
        List<PrdDatakeyMapping> tDatakeyMappings = this.prdDatakeyMappingDao.fetch(tCondition);
        if (CollectionUtils.isNotEmpty(tDatakeyMappings)) {
            for (PrdDatakeyMapping tDatakeyMapping : tDatakeyMappings) {
                if (tDatakeyMapping.getEocLevel().equals(EocLevelEnum.site_id.toString())) {
                    dispatchLevel = 1;
                    continue;
                }
                if (!tDatakeyMapping.getEocLevel().equals(EocLevelEnum.region_id.toString())) continue;
                dispatchLevel = 2;
            }
        }
        ArrayList<Map<String, Object>> tDispatchAryNode = new ArrayList<Map<String, Object>>();
        for (String key : tTotalMap.get(tTenantId).get(tProdName).keySet()) {
            boolean tMappingsNoDatakeyValue = true;
            for (EocIntgMapping mapping : tTotalMap.get(tTenantId).get(tProdName).get(key)) {
                HashMap tDispatchItemNode = new HashMap();
                if (StringUtil.isEmptyOrSpace(mapping.getDatakey())) continue;
                HashMap<String, String> tServiceProductNode = new HashMap<String, String>();
                tDispatchItemNode.put("service_product", tServiceProductNode);
                tServiceProductNode.put("name", mapping.getProducName());
                tServiceProductNode.put("uid", mapping.getProductUid());
                HashMap<String, String> tOperationManagerNode = new HashMap<String, String>();
                if (mapping.getCloudMappingType().equals(EocLevelEnum.company_id.toString()) && dispatchLevel == 0) {
                    tDispatchAryNode.add(tDispatchItemNode);
                    tOperationManagerNode.put("eoc_mapping_id", mapping.getEocId());
                    tOperationManagerNode.put("type", mapping.getCloudMappingType());
                } else if (mapping.getCloudMappingType().equals(EocLevelEnum.site_id.toString()) && dispatchLevel == 1) {
                    tDispatchAryNode.add(tDispatchItemNode);
                    tOperationManagerNode.put("eoc_mapping_id", mapping.getEocId());
                    tOperationManagerNode.put("type", mapping.getCloudMappingType());
                } else if (mapping.getCloudMappingType().equals(EocLevelEnum.region_id.toString()) && dispatchLevel == 2) {
                    tDispatchAryNode.add(tDispatchItemNode);
                    tOperationManagerNode.put("eoc_mapping_id", mapping.getEocId());
                    tOperationManagerNode.put("type", mapping.getCloudMappingType());
                }
                tDispatchItemNode.put("operation_manager", tOperationManagerNode);
                tMappingsNoDatakeyValue = false;
            }
            if (!tMappingsNoDatakeyValue) continue;
            HashMap tDispatchItemNode = new HashMap();
            HashMap<String, String> tServiceProductNode = new HashMap<String, String>();
            tDispatchItemNode.put("service_product", tServiceProductNode);
            tServiceProductNode.put("name", tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProducName());
            tServiceProductNode.put("uid", tTotalMap.get(tTenantId).get(tProdName).get(key).get(0).getProductUid());
            tDispatchAryNode.add(tDispatchItemNode);
        }
        return tDispatchAryNode;
    }

    public Map<String, Map<String, Map<String, List<EocIntgMapping>>>> groupEocMappingByTenantAndProdNameAndUid(List<EocIntgMapping> pEocIntgMappings, String pTenantId) {
        HashMap<String, Map<String, Map<String, List<EocIntgMapping>>>> tTotalMap = new HashMap<String, Map<String, Map<String, List<EocIntgMapping>>>>();
        for (EocIntgMapping mapping : pEocIntgMappings) {
            ArrayList<EocIntgMapping> tEocIntgMappingList;
            HashMap<String, ArrayList<EocIntgMapping>> tProductUidMap;
            HashMap tProductNameMap = (HashMap)tTotalMap.get(pTenantId);
            if (MapUtils.isEmpty((Map)tProductNameMap)) {
                tProductNameMap = new HashMap();
                tTotalMap.put(pTenantId, tProductNameMap);
            }
            if (MapUtils.isEmpty((Map)(tProductUidMap = (HashMap<String, ArrayList<EocIntgMapping>>)tProductNameMap.get(mapping.getProducName())))) {
                tProductUidMap = new HashMap<String, ArrayList<EocIntgMapping>>();
                tProductNameMap.put(mapping.getProducName(), tProductUidMap);
            }
            if (CollectionUtils.isEmpty((Collection)(tEocIntgMappingList = (ArrayList<EocIntgMapping>)tProductUidMap.get(mapping.getProductUid())))) {
                tEocIntgMappingList = new ArrayList<EocIntgMapping>();
                tProductUidMap.put(mapping.getProductUid(), tEocIntgMappingList);
            }
            tEocIntgMappingList.add(mapping);
        }
        return tTotalMap;
    }
}

