/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.TotalHits;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchService {
    private final Log log = LogFactory.getLog(this.getClass());
    ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Value(value="${asset_index_name:asset}")
    private String assertIndexName;

    public void insertAssetDataDoc(String docId, Map<String, Object> docMessage) throws Exception {
        IndexRequest indexRequest = new IndexRequest(this.assertIndexName);
        indexRequest.source(JSON.toJSONString(docMessage), XContentType.JSON);
        indexRequest.id(docId);
        try {
            this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.log.error((Object)("\u65b0\u589e\u6587\u6863\u5931\u8d25,id: " + docId + " \u5f02\u5e38 " + e));
        }
    }

    public ObjectNode searchAssetDataDoc(Map<String, String> mapCondition) {
        ObjectNode objectNode = this.objectMapper.createObjectNode();
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.indices(new String[]{this.assertIndexName});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.from(Integer.parseInt(mapCondition.get("from")));
        searchSourceBuilder.size(Integer.parseInt(mapCondition.get("size")));
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        List queryBuilders = boolQueryBuilder.must();
        if (null != mapCondition.get("property_source")) {
            queryBuilders.add(QueryBuilders.termQuery((String)"property_source.keyword", (String)mapCondition.get("property_source")));
        }
        if (null != mapCondition.get("property_type")) {
            queryBuilders.add(QueryBuilders.termQuery((String)"property_type.keyword", (String)mapCondition.get("property_type")));
        }
        if (null != mapCondition.get("code")) {
            queryBuilders.add(QueryBuilders.termQuery((String)"code.keyword", (String)mapCondition.get("code")));
        }
        if (null != mapCondition.get("name")) {
            queryBuilders.add(QueryBuilders.matchQuery((String)"name", (Object)mapCondition.get("name")));
            queryBuilders.add(QueryBuilders.matchQuery((String)"content.tables.name", (Object)mapCondition.get("name")));
            queryBuilders.add(QueryBuilders.matchQuery((String)"content.tables.fields.name", (Object)mapCondition.get("name")));
        }
        if (null != mapCondition.get("owner_product")) {
            queryBuilders.add(QueryBuilders.termQuery((String)"owner_product.keyword", (String)mapCondition.get("owner_product")));
        }
        if (null != mapCondition.get("content")) {
            queryBuilders.add(QueryBuilders.matchPhraseQuery((String)"content", (Object)mapCondition.get("content")));
        }
        if (null != mapCondition.get("property_comment")) {
            queryBuilders.add(QueryBuilders.matchPhraseQuery((String)"property_comment", (Object)mapCondition.get("property_comment")));
        }
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        searchRequest.source(searchSourceBuilder);
        this.log.info((Object)("\u67e5\u8be2\u8bed\u53e5\uff1a" + searchRequest.toString()));
        try {
            SearchResponse search = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits searchHits = search.getHits();
            if (null != searchHits) {
                SearchHit[] searchHitsHits;
                TotalHits totalHits = searchHits.getTotalHits();
                long count = totalHits.value;
                objectNode.put("count", count);
                objectNode.put("from", Integer.parseInt(mapCondition.get("from")));
                objectNode.put("size", Integer.parseInt(mapCondition.get("size")));
                ArrayNode arrayNode = this.objectMapper.createArrayNode();
                objectNode.set("data", (JsonNode)arrayNode);
                for (SearchHit searchHit : searchHitsHits = searchHits.getHits()) {
                    Map map = searchHit.getSourceAsMap();
                    ObjectNode jsonNodes = this.objectMapper.createObjectNode();
                    jsonNodes.put("code", null == map.get("code") ? null : map.get("code").toString());
                    jsonNodes.put("name", null == map.get("name") ? null : map.get("name").toString());
                    jsonNodes.put("owner_product", null == map.get("owner_product") ? null : map.get("owner_product").toString());
                    jsonNodes.put("property_source", null == map.get("property_source") ? null : map.get("property_source").toString());
                    jsonNodes.put("property_type", null == map.get("property_type") ? null : map.get("property_type").toString());
                    jsonNodes.put("property_content", null == map.get("content") ? null : map.get("content").toString());
                    arrayNode.add((JsonNode)jsonNodes);
                }
            }
        }
        catch (IOException exception) {
            exception.printStackTrace();
            this.log.error((Object)("\u67e5\u8be2es\u5931\u8d25\uff1a" + exception.getMessage()));
        }
        return objectNode;
    }

    public void deleteAssetDataDoc(String docId) throws Exception {
        DeleteRequest deleteRequest = new DeleteRequest(this.assertIndexName, docId);
        try {
            this.restHighLevelClient.delete(deleteRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.log.info((Object)("\u5220\u9664\u6587\u6863\u5931\u8d25,id: " + docId + " \u5f02\u5e38 " + e));
        }
    }
}

