/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.http.client.DWHttpClient;
import com.digiwin.http.client.DWRequestOption;
import com.digiwin.http.client.entity.DWJsonEntity;
import com.digiwin.http.client.exception.DWHttpFailedException;
import com.digiwin.http.client.utils.DWURIBuilder;
import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.enums.EocOperationTypeEnum;
import com.digiwin.metadatacache.exception.DeleteCompanyEocFailedException;
import com.digiwin.metadatacache.exception.EocCompanyInfoRetrievedException;
import com.digiwin.metadatacache.exception.EocEnterpriseInfoRetrievedException;
import com.digiwin.metadatacache.exception.EocFailedException;
import com.digiwin.metadatacache.exception.TokenNotRetrievedException;
import com.digiwin.metadatacache.exception.UpdateEocFailedException;
import com.digiwin.metadatacache.util.StringUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class EocInfoService {
    private final Log log = LogFactory.getLog(this.getClass());
    ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private DWHttpClient dwHttpClient;
    @Value(value="${iamApToken}")
    private String iamApToken;

    public ObjectNode getEocInfoByTenantId(String pTenantId) throws Exception {
        String tToken = this.getTokenByTenant(pTenantId);
        return this.getEocInfoByUserToken(tToken);
    }

    public ObjectNode getEocInfoV2ByTenantId(String pTenantId) throws Exception {
        String tToken = this.getTokenByTenant(pTenantId);
        return this.getEocInfoV2ByUserToken(tToken);
    }

    private String getTokenByTenant(String tenantId) throws Exception {
        try {
            URI tIamTargetUri = DWURIBuilder.create((String)"iam", (String)"/api/iam/v2/identity/login/internal").build();
            HttpPost tPost = new HttpPost(tIamTargetUri);
            HashMap<String, String> tRequestEntity = new HashMap<String, String>();
            tRequestEntity.put("identityType", "internal");
            tRequestEntity.put("userId", "integration");
            tRequestEntity.put("passwordHash", "6826CC688C4AF1BD0A8DDA2DBDF8897B");
            tRequestEntity.put("tenantId", tenantId);
            tPost.setEntity((HttpEntity)new DWJsonEntity(tRequestEntity));
            tPost.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tPost.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            Map tResponseEntity = (Map)this.dwHttpClient.execute((HttpUriRequest)tPost, Map.class, new DWRequestOption(false));
            return (String)tResponseEntity.get("token");
        }
        catch (DWHttpFailedException e) {
            Map tFailedEntity = (Map)e.getEntity(Map.class);
            String tMsg = String.format("IAM response: %s", tFailedEntity.get("message"));
            throw new TokenNotRetrievedException(tMsg, this.getClass());
        }
        catch (Exception e) {
            throw new TokenNotRetrievedException(e, this.getClass());
        }
    }

    public ObjectNode getEocInfoByUserToken(String pToken) throws Exception {
        try {
            this.log.info((Object)("\u6839\u64datoken\uff1a" + pToken + "\u53d6\u5f97EOC\u8cc7\u8a0a"));
            URI tTargetUri = DWURIBuilder.create((String)"eoc", (String)"/api/eoc/v2/corp/all").build();
            HttpGet tGet = new HttpGet(tTargetUri);
            tGet.addHeader("token", pToken);
            tGet.addHeader("digi-middleware-auth-user", pToken);
            tGet.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tGet.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            String tResponseEntity = (String)this.dwHttpClient.execute((HttpUriRequest)tGet, String.class, new DWRequestOption(false));
            ObjectNode tTotalEocNode = (ObjectNode)this.mapper.readTree(tResponseEntity);
            this.log.info((Object)("\u53d6\u5f97EOC\u8cc7\u8a0a\uff1a" + tTotalEocNode.toString()));
            return tTotalEocNode;
        }
        catch (DWHttpFailedException e) {
            Map tFailedEntity = (Map)e.getEntity(Map.class);
            String tMsg = String.format("Eoc response: %s", tFailedEntity.get("message"));
            throw new EocFailedException(tMsg, this.getClass());
        }
        catch (Exception e) {
            if (!StringUtil.isEmptyOrSpace(e.getMessage())) {
                throw new EocFailedException(e.getMessage(), this.getClass());
            }
            throw new EocFailedException(e.getCause(), this.getClass());
        }
    }

    public ObjectNode getEocInfoV2ByUserToken(String pToken) throws Exception {
        try {
            this.log.info((Object)("method=getEocInfoV2ByUserToken,\u6839\u64datoken\uff1a" + pToken + "\u53d6\u5f97EOC\u8cc7\u8a0a"));
            URI tTargetUri = DWURIBuilder.create((String)"eoc", (String)"/api/eoc/v2/operation/unit/search").addParameter("status", (Object)true).build();
            HttpGet tGet = new HttpGet(tTargetUri);
            tGet.addHeader("token", pToken);
            tGet.addHeader("digi-middleware-auth-user", pToken);
            tGet.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tGet.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            String tResponseEntity = (String)this.dwHttpClient.execute((HttpUriRequest)tGet, String.class, new DWRequestOption(false));
            ObjectNode tTotalEocNode = (ObjectNode)this.mapper.readTree(tResponseEntity);
            this.log.info((Object)("method=getEocInfoV2ByUserToken,\u53d6\u5f97EOC\u8cc7\u8a0a\uff1a" + tTotalEocNode.toString()));
            return tTotalEocNode;
        }
        catch (DWHttpFailedException e) {
            Map tFailedEntity = (Map)e.getEntity(Map.class);
            String tMsg = String.format("Eoc response: %s", tFailedEntity.get("message"));
            throw new EocFailedException(tMsg, this.getClass());
        }
        catch (Exception e) {
            if (!StringUtil.isEmptyOrSpace(e.getMessage())) {
                throw new EocFailedException(e.getMessage(), this.getClass());
            }
            throw new EocFailedException(e.getCause(), this.getClass());
        }
    }

    public String updateEocEntry(String pSid, String pEocId, String pToken, int pLevel, int pTypeSid, String pParentSid, int pState) throws Exception {
        try {
            URI tEocTargetUri = DWURIBuilder.create((String)(MdcApplicationParameter._EOC_HOST + "/api/eoc/v2/corp/company/factory")).build();
            HttpPost tPost = new HttpPost(tEocTargetUri);
            ObjectNode objectNode = this.mapper.createObjectNode();
            if (pLevel == 2) {
                objectNode.put("sid", pSid);
                objectNode.put("id", pEocId);
                objectNode.put("name", pEocId);
                objectNode.put("typeSid", pTypeSid);
                objectNode.put("parentSid", pParentSid);
                objectNode.put("level", pLevel);
            } else if (pLevel == 3) {
                objectNode.put("level", pLevel);
                ArrayNode arrayNode = this.mapper.createArrayNode();
                objectNode.set("factories", (JsonNode)arrayNode);
                ObjectNode siteNode = this.mapper.createObjectNode();
                siteNode.put("sid", pSid);
                siteNode.put("id", pEocId);
                siteNode.put("name", pEocId);
                siteNode.put("typeSid", pTypeSid);
                siteNode.put("parentSid", pParentSid);
                siteNode.put("level", pLevel);
                siteNode.put("state", pState);
                arrayNode.add((JsonNode)siteNode);
            }
            StringEntity entity = new StringEntity(objectNode.toString(), "UTF-8");
            entity.setContentEncoding("UTF-8");
            tPost.setEntity((HttpEntity)entity);
            tPost.setHeader("digi-middleware-auth-user", pToken);
            tPost.setHeader("token", pToken);
            tPost.setHeader("Content-Type", "application/json");
            tPost.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tPost.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            String result = (String)this.dwHttpClient.execute((HttpUriRequest)tPost, String.class, new DWRequestOption(false));
            JsonNode tResultNode = this.mapper.readTree(result);
            String tOperation = "";
            if (pLevel == 2) {
                if (pState == 0) {
                    tOperation = EocOperationTypeEnum.add.toString();
                    this.log.info((Object)("\u65b0\u589e\u96f2\u63a7\u5236\u53f0\u516c\u53f8\u5c64\u7d1aeoc\uff1a" + pEocId + result));
                }
            } else if (pLevel == 3) {
                if (pState == 0) {
                    tOperation = EocOperationTypeEnum.add.toString();
                    this.log.info((Object)("\u65b0\u589e\u96f2\u63a7\u5236\u53f0\u5de5\u5ee0\u5c64\u7d1aeoc\uff1a" + pEocId + result));
                } else if (pState == 1) {
                    tOperation = EocOperationTypeEnum.delete.toString();
                    this.log.info((Object)("\u522a\u9664\u96f2\u63a7\u5236\u53f0\u5de5\u5ee0\u5c64\u7d1aeoc\uff1a" + pEocId + result));
                }
            }
            if (tResultNode.get("code") == null || !tResultNode.get("code").asText().matches("200")) {
                if (tOperation.equals(EocOperationTypeEnum.add.toString())) {
                    throw new UpdateEocFailedException(tResultNode.get("errorMessage").asText(), this.getClass());
                }
                if (tOperation.equals(EocOperationTypeEnum.delete.toString())) {
                    throw new DeleteCompanyEocFailedException(tResultNode.get("errorMessage").asText(), this.getClass());
                }
            }
            return result;
        }
        catch (UpdateEocFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UpdateEocFailedException(e.getMessage(), this.getClass());
        }
    }

    public String getEnterPriseSid(String pToken) throws Exception {
        try {
            String tResponse;
            JsonNode tResponseNode;
            URI tEocTargetUri = DWURIBuilder.create((String)(MdcApplicationParameter._EOC_HOST + "/api/eoc/v2/corp/simple")).build();
            HttpGet tHttpGet = new HttpGet(tEocTargetUri);
            tHttpGet.addHeader("token", pToken);
            tHttpGet.setHeader("digi-middleware-auth-user", pToken);
            tHttpGet.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tHttpGet.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            if ((tResponseNode = this.mapper.readTree(tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, String.class, new DWRequestOption(false)))).get("data") == null) {
                throw new EocEnterpriseInfoRetrievedException(tResponseNode.get("errorMessage").asText(), this.getClass());
            }
            JsonNode tDataNode = tResponseNode.get("data");
            if (tDataNode.get("sid") != null) {
                return tDataNode.get("sid").asText();
            }
            return null;
        }
        catch (EocEnterpriseInfoRetrievedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EocEnterpriseInfoRetrievedException(e.getMessage(), this.getClass());
        }
    }

    public String getCompanySid(String pToken, String pEocId) throws Exception {
        try {
            String tResponse;
            JsonNode tResponseNode;
            URI tEocTargetUri = DWURIBuilder.create((String)(MdcApplicationParameter._EOC_HOST + "/api/eoc/v2/corp/company")).addParameter("pageSize", "99999").build();
            HttpGet tHttpGet = new HttpGet(tEocTargetUri);
            tHttpGet.addHeader("token", pToken);
            tHttpGet.setHeader("digi-middleware-auth-user", pToken);
            tHttpGet.setHeader("digi-middleware-auth-app", this.iamApToken);
            if (null != DWServiceContext.getContext().getRequestHeader().get("routerKey")) {
                tHttpGet.setHeader("routerKey", DWServiceContext.getContext().getRequestHeader().get("routerKey").toString());
            }
            if ((tResponseNode = this.mapper.readTree(tResponse = (String)this.dwHttpClient.execute((HttpUriRequest)tHttpGet, String.class, new DWRequestOption(false)))).get("data") == null) {
                throw new EocCompanyInfoRetrievedException(tResponseNode.get("errorMessage").asText(), this.getClass());
            }
            JsonNode tDataNode = tResponseNode.get("data");
            if (tDataNode.get("list") != null) {
                ArrayNode tCompanyListNode = (ArrayNode)tDataNode.get("list");
                for (JsonNode tCompanyNode : tCompanyListNode) {
                    if (!tCompanyNode.get("id").asText().equals(pEocId)) continue;
                    return tCompanyNode.get("sid").asText();
                }
            }
            return null;
        }
        catch (EocCompanyInfoRetrievedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EocCompanyInfoRetrievedException(e.getMessage(), this.getClass());
        }
    }

    private static String decodeAES(String secretFile) throws Exception {
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        SecretKeySpec key1 = new SecretKeySpec(Hex.decodeHex((char[])secretKey.toCharArray()), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, key1);
        byte[] result = cipher.doFinal(Hex.decodeHex((char[])secretFile.toCharArray()));
        return new String(result);
    }
}

