/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.metadatacache.services;

import com.digiwin.metadatacache.MdcApplicationParameter;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.enums.ApiTypeEnum;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.services.MdcCacheService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MdcProductService {
    private static final Log log = LogFactory.getLog(MdcProductService.class);
    @Autowired
    private ServiceDao serviceDao;
    @Autowired
    private MdcCacheService cacheService;

    public Map<String, List<Product>> getProductFromDb(String tenantId, List<String> apiNames, Map<String, String> apiRelationMap) {
        List<String> realApiNames = apiNames.stream().map(api -> apiRelationMap.containsKey(api) ? (String)apiRelationMap.get(api) : api).collect(Collectors.toList());
        List<com.digiwin.metadatacache.model.Service> tServices = this.serviceDao.getByServiceNames(realApiNames);
        HashMap<String, List<Product>> productMap = new HashMap<String, List<Product>>();
        if (CollectionUtils.isEmpty(tServices)) {
            return productMap;
        }
        boolean isStandard = true;
        List<com.digiwin.metadatacache.model.Service> serviceList = tServices.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.standard.toString()) && null != x.getProduct().getTenantId() && tenantId.equals(x.getProduct().getTenantId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(serviceList)) {
            isStandard = false;
            serviceList = tServices.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.agile.toString())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(serviceList)) {
            return productMap;
        }
        this.saveToCache(serviceList, tenantId, isStandard);
        HashMap realApiProdMap = new HashMap();
        serviceList.forEach(srv -> {
            List prod = realApiProdMap.computeIfAbsent(srv.getName(), k -> new ArrayList());
            prod.add(srv.getProduct());
        });
        apiNames.stream().forEach(api -> {
            String realName;
            String string = realName = apiRelationMap.containsKey(api) ? (String)apiRelationMap.get(api) : api;
            if (realApiProdMap.containsKey(realName)) {
                productMap.put((String)api, (List<Product>)realApiProdMap.get(realName));
            }
        });
        return productMap;
    }

    public List<Product> getProductFromDb(String tenantId, String apiName, String prod, String uid) {
        List<com.digiwin.metadatacache.model.Service> tServices = this.serviceDao.getByPrdAndServiceName(prod, uid, apiName);
        if (CollectionUtils.isEmpty(tServices)) {
            return null;
        }
        boolean isStandard = true;
        List<com.digiwin.metadatacache.model.Service> serviceList = tServices.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.standard.toString()) && null != x.getProduct().getTenantId() && tenantId.equals(x.getProduct().getTenantId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(serviceList)) {
            isStandard = false;
            serviceList = tServices.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.agile.toString())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(serviceList)) {
            return null;
        }
        this.saveToCache(serviceList, tenantId, isStandard);
        return serviceList.stream().map(com.digiwin.metadatacache.model.Service::getProduct).collect(Collectors.toList());
    }

    public List<Product> getProductFromDbNoCache(String tenantId, String apiName, String prod, String uid) {
        List<com.digiwin.metadatacache.model.Service> tServices = this.serviceDao.getByPrdAndServiceName(prod, uid, apiName);
        if (CollectionUtils.isEmpty(tServices)) {
            return null;
        }
        List serviceList = tServices.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.standard.toString()) && null != x.getProduct().getTenantId() && tenantId.equals(x.getProduct().getTenantId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(serviceList)) {
            serviceList = tServices.stream().filter(x -> x.getProduct().getProductType().equals(ApiTypeEnum.agile.toString())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(serviceList)) {
            return null;
        }
        return serviceList.stream().map(com.digiwin.metadatacache.model.Service::getProduct).collect(Collectors.toList());
    }

    public void saveToCache(List<com.digiwin.metadatacache.model.Service> services, String tenantId, boolean isStandard) {
        if (isStandard) {
            String tStandardKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + tenantId;
            HashMap<String, List> standardCache = (HashMap<String, List>)this.cacheService.get(tStandardKey);
            if (null == standardCache) {
                standardCache = new HashMap<String, List>();
            }
            for (com.digiwin.metadatacache.model.Service srv : services) {
                Product product = srv.getProduct();
                String key = this.buildStandardProductKey(product);
                List srvCache = standardCache.computeIfAbsent(key, k -> new ArrayList());
                if (CollectionUtils.isEmpty((Collection)srvCache)) {
                    srvCache.add(this.buildProductInfo(product));
                }
                srvCache.add(srv.getName() + "/");
            }
            this.cacheService.setSync(tStandardKey, standardCache);
        } else {
            String tAgileKeyPrefix = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + "agile" + ":";
            services.stream().collect(Collectors.groupingBy(com.digiwin.metadatacache.model.Service::getName)).forEach((srvName, srvs) -> {
                String key = tAgileKeyPrefix + srvName;
                HashMap<String, String> tAgileProductMap = (HashMap<String, String>)this.cacheService.get(key);
                if (null == tAgileProductMap) {
                    tAgileProductMap = new HashMap<String, String>();
                }
                for (com.digiwin.metadatacache.model.Service srv : srvs) {
                    String productKey = this.buildAgileProductKey(srv.getProduct());
                    String productInfo = this.buildProductInfo(srv.getProduct()) + ":::";
                    tAgileProductMap.put(productKey, productInfo);
                }
                this.cacheService.setSyncTimeOut(key, tAgileProductMap, MdcApplicationParameter._TIME_OUT + (long)((int)(Math.random() * (double)MdcApplicationParameter._TIME_RANDOM)));
            });
        }
    }

    public List<Product> getStandardProductCache(String tenantId, Map<String, List<String>> standardCache, String pApiName) {
        if (null == standardCache) {
            return null;
        }
        HashSet<String> productCacheInfos = new HashSet<String>();
        block0: for (String tProductInfoKey : standardCache.keySet()) {
            List<String> apiInfoList = standardCache.get(tProductInfoKey);
            if (!CollectionUtils.isNotEmpty(apiInfoList)) continue;
            for (String tApiInfo : apiInfoList.subList(1, apiInfoList.size())) {
                String[] tApiInfoSplitAry = tApiInfo.split("/");
                String tApiName = tApiInfoSplitAry[0];
                if (!pApiName.matches(tApiName)) continue;
                productCacheInfos.add(apiInfoList.get(0));
                continue block0;
            }
        }
        return CollectionUtils.isEmpty(productCacheInfos) ? null : this.parseToProductInfo(tenantId, pApiName, productCacheInfos, ApiTypeEnum.standard.toString());
    }

    public List<Product> getAgileProductCache(String tenantId, String pApiName) {
        String tAgileKey = CacheMapTypeEnum.tenant_product_mapping_list.getCode() + ":" + "agile" + ":" + pApiName;
        Map tProductServiceList = (Map)this.cacheService.get(tAgileKey);
        if (null == tProductServiceList) {
            return null;
        }
        log.info((Object)("\u547d\u4e2d\u5feb\u53d6: " + tAgileKey));
        HashSet<String> productCacheInfos = new HashSet<String>();
        for (String tProductInfoKey : tProductServiceList.keySet()) {
            String[] tApiInfoSplitAry = ((String)tProductServiceList.get(tProductInfoKey)).split(":::");
            productCacheInfos.add(tApiInfoSplitAry[0]);
        }
        return CollectionUtils.isEmpty(productCacheInfos) ? null : this.parseToProductInfo(tenantId, pApiName, productCacheInfos, ApiTypeEnum.agile.toString());
    }

    private List<Product> parseToProductInfo(String tenantId, String apiName, Set<String> productCacheInfos, String productType) {
        HashMap<String, Product> productVOS = new HashMap<String, Product>();
        for (String productCacheInfo : productCacheInfos) {
            String[] tProductInfoSplitAry = productCacheInfo.split("/");
            String tProductName = tProductInfoSplitAry[0];
            String tProductUid = tProductInfoSplitAry[1];
            String tProductVersion = tProductInfoSplitAry[3];
            String tProductIp = tProductInfoSplitAry[4];
            String tProductId = tProductInfoSplitAry[5];
            String tProductGatewayId = tProductInfoSplitAry[6];
            String title = tProductName + tProductUid + tProductVersion + tProductIp + tProductId + tProductGatewayId;
            if (productVOS.containsKey(title)) {
                log.info((Object)("\u91cd\u590d\u6570\u636e\u5c55\u793a,\u79df\u6237Id: " + tenantId + "api\u540d\u79f0: " + apiName + "redis\u5185\u5bb9\u89e3\u6790: " + title));
                continue;
            }
            Product product = new Product();
            productVOS.put(title, product);
            product.setGatewayId(tProductGatewayId);
            product.setName(tProductName);
            product.setVersion(tProductVersion);
            product.setIp(tProductIp);
            product.setApid(tProductId);
            product.setUid(tProductUid);
            product.setProductType(productType);
        }
        return Lists.newArrayList(productVOS.values());
    }

    private String buildAgileProductKey(Product product) {
        return product.getName() + ":" + product.getUid();
    }

    private String buildStandardProductKey(Product product) {
        return product.getName() + ":" + product.getUid() + ":" + product.getEaiUid();
    }

    private String buildProductInfo(Product product) {
        return product.getName() + "/" + product.getUid() + "/" + product.getEaiUid() + "/" + product.getVersion() + "/" + product.getIp() + "/" + product.getApid() + "/" + product.getGatewayId();
    }
}

