package com.digiwin.metadatacache;


import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.orm.jpa.EntityManagerHolder;

@SpringBootApplication
@ComponentScan(basePackages = {"com.digiwin.gateway", "com.digiwin.athena","com.digiwin.metadatacache"})
public class AppMdc {

    public static void main(String[] args) {
        try {
            SpringApplication springApplication = new SpringApplication(AppMdc.class);
            springApplication.addListeners(new ApplicationPidFileWriter("DWApiGatewayApplication.pid"));
            springApplication.run(args);
        } catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }

        EntityManagerHolder aa;
        MongoAutoConfiguration aaa;

    }

}
