package com.digiwin.metadatacache.apiservice;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.digiwin.metadatacache.dao.ApiVersionDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.ApiVersion;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得新增或修改的API清單
 * 根据创建时间+接收者信息查询API清单列表
 * Path:[/restful/standard/mdc/ApiInfo/Get]
 */
@Service
public class ApiInfoGet extends AbstractApiService {

	private final SimpleDateFormat gDateFormat4Gwt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");

	@Autowired
	private ApiVersionDao apiVersionDao;

	public ApiInfoGet() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.API_INFO_GET_SCHEMA;
	}

	/**
	 * 查询API
	 * @param validatorResult      * @param validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tBuildTime = tRequestJsonNode.get(MdcConstant.BUILD_TIME).asText();
		String tProvider = null;
		if (tRequestJsonNode.get(MdcConstant.PROVIDER) != null) {
			tProvider = tRequestJsonNode.get(MdcConstant.PROVIDER).asText();
		}
		Date tDate;
		Calendar tCalender = null;
		try {
			tDate = gDateFormat4Gwt.parse(tBuildTime);
			tCalender = Calendar.getInstance();
			tCalender.setTime(tDate);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		List<ApiVersion> tApiVersionList = apiVersionDao.getApiInfo(tCalender, tProvider);
		// 組成回傳訊息
		// 建立data節點
		ObjectNode tDataNode = mapper.createObjectNode();
		// 建立應用、版本陣列
		ArrayNode tVersionAryNode = mapper.createArrayNode();
		if (tApiVersionList != null) {
			for (ApiVersion tApiVersion : tApiVersionList) {
				// 檢查產品名稱是否完全符合
				boolean tBoolean = false;
				if (tProvider != null) {
					String tProviders = tApiVersion.getApi().getProvider().trim();
					String[] tProviderArr = tProviders.split(",");
					for (String s : tProviderArr) {
						if (s.trim().equals(tProvider)) {
							tBoolean = true;
							break;
						}
					}
				} else {
					tBoolean = true;
				}
				if (tBoolean) {
					ObjectNode tAppVerNode = mapper.createObjectNode();
					tAppVerNode.put(MdcConstant.API_NAME, tApiVersion.getApi().getName().trim());
					tAppVerNode.put(MdcConstant.API_VERSION, tApiVersion.getVersion().trim());
					tAppVerNode.put(MdcConstant.PROVIDER, tApiVersion.getApi().getProvider().trim());
					// 建立Description節點
					ObjectNode tDescriptionNode = mapper.createObjectNode();
					tDescriptionNode.put(MdcConstant.ZH_TW, tApiVersion.getApi().getDescriptionZhTw().trim());
					tDescriptionNode.put(MdcConstant.ZH_CN, tApiVersion.getApi().getDescriptionZhCn().trim());
					tDescriptionNode.put(MdcConstant.EN, tApiVersion.getApi().getDescriptionEn().trim());
					tAppVerNode.set(MdcConstant.DESCRIPTION, tDescriptionNode);
					// 建立Remark節點
					ObjectNode tRemarkNode = mapper.createObjectNode();
					tRemarkNode.put(MdcConstant.ZH_TW, tApiVersion.getApi().getRemarkZhTw().trim());
					tRemarkNode.put(MdcConstant.ZH_CN, tApiVersion.getApi().getRemarkZhCn().trim());
					tRemarkNode.put(MdcConstant.EN, tApiVersion.getApi().getRemarkEn().trim());
					tAppVerNode.set(MdcConstant.REMARK, tRemarkNode);
					tAppVerNode.put(MdcConstant.APPROVED_STATUS, tApiVersion.getApprovedStatus().toString().trim());
					tVersionAryNode.add(tAppVerNode);
				}
			}
		}
		tDataNode.set(MdcConstant.API_VER, tVersionAryNode);
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tDataNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}
