package com.digiwin.metadatacache.apiservice;

import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.constant.MdcSymbolConstant;
import com.digiwin.metadatacache.services.LoadCacheService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.digiwin.app.redis.service.DWRedisService;
import com.digiwin.metadatacache.enums.CacheMapTypeEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 清除快取
 * Path:[/restful/standard/mdc/CleanCache]
 */
@Service
public class CleanCacheService extends AbstractApiService {

    @Autowired
    private DWRedisService redisService;

    @Autowired
    private LoadCacheService loadCacheService;

    public CleanCacheService() {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.CLEAN_CACHE_SCHEMA;
    }

    /**
     * 缓存清除
     *
     * @param validatorResult * @param validatorResult
     * @return Map
     * @throws BaseException BaseException
     * @throws Exception     Exception
     */
    @Override
    protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        String tType = tRequestJsonNode.get(MdcConstant.TYPE).asText();
        switch (tType) {
            case "all":
                CacheMapTypeEnum[] tCacheEnums = CacheMapTypeEnum.values();
                String[] tCacheKeys = new String[tCacheEnums.length];
                for (int i = 0; i < tCacheEnums.length; i++) {
                    tCacheKeys[i] = tCacheEnums[i].getCode();
                }
                redisService.remove(tCacheKeys);
                cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                cacheService.removeByPattern(CacheMapTypeEnum.api_version_list.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "dispatch":
                cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_dispatch_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "organizationList":
                cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_operation_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "omTenant":
                cacheService.removeByPattern(CacheMapTypeEnum.om_tenant_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "globalParam":
                cacheService.removeByPattern(CacheMapTypeEnum.global_param_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
//            case "tenantProductListUpdate":
//                cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_list_update_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
//                break;
            case "apiMetadata":
                cacheService.removeByPattern(CacheMapTypeEnum.api_metadata_cachemap.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "tenantProductMappingList":
                cacheService.removeByPattern(CacheMapTypeEnum.tenant_product_mapping_list.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "apiVersionList":
                cacheService.removeByPattern(CacheMapTypeEnum.api_version_list.getCode() + MdcSymbolConstant.ASTERISK_SYMBOL);
                break;
            case "apiBaseInfo":
                loadCacheService.removeAllData();
                break;
            default:
                break;
        }
        StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
        String tDescription = getDescriptionByLocale(tStateCode, locale);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        return converJsonNodeToMap(tResponseJsonNode);
    }

}
