package com.digiwin.metadatacache.apiservice;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.EocLevelEnum;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.util.StringUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author clay
 * on 2025/3/26
 */

/**
 * 取得產品主機的雲地映射
 * Path:[/restful/standard/mdc/CloudMappingSetting/Get]
 */
@Service
public class CloudMappingSettingGetService extends AbstractApiService {

    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    public CloudMappingSettingGetService () {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.CLOUD_MAPPING_SETTING_GET_SCHEMA;
    }

    @Override
    protected Map<String, Object> processData (ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
                         + ", 原始訊息: " + tRequestJsonNode);
        // 取出入參tenant
        String tenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
        String prodName = tRequestJsonNode.get(MdcConstant.PROD_NAME).asText();
        String uid = tRequestJsonNode.get(MdcConstant.UID).asText();

        String tEnterPriseId = null;
        if (tRequestJsonNode.get(MdcConstant.ENTERPRISE_ID) != null
                && !StringUtil.isEmptyOrSpace(tRequestJsonNode.get(MdcConstant.ENTERPRISE_ID).asText())) {
            tEnterPriseId = tRequestJsonNode.get(MdcConstant.ENTERPRISE_ID).asText();
        }
        return getOperationManageSettingV2(tenantId, prodName, uid, tEnterPriseId);
    }

    /**
     * 取得租戶特定產品的運營清單 v2版本
     * @param pTenantId 租户ID
     * @param pProdName 产品名称
     * @param pUid      产品UID
     * @param pEnterPriseId  pEnterPriseId
     * @return Map
     * @throws Exception Exception
     */
    private Map<String, Object> getOperationManageSettingV2(String pTenantId, String pProdName, String pUid, String pEnterPriseId) throws Exception {
        List<EocIntgMapping> tEnterpriseIdMappings = new ArrayList<>();

        List<EocIntgMapping> tRegionIdMappings = new ArrayList<>();
        // 取得已配置數據 v2条件查询
        Map<String, String> pCondition = new HashMap<>();
        pCondition.put(MdcConstant.TENANT_ID, pTenantId);
        pCondition.put(MdcConstant.PROD_NAME, pProdName);
        pCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
        if (pUid != null) {
            pCondition.put(MdcConstant.UID, pUid);
        }
        List<EocIntgMapping> tEocIntgMappings = eocIntgMappingDao.fetch(pCondition);

        //取得雲上eoc v2新接口
        Map<String, String> eocIdMapping = EocInfoServiceUtil.getEocInfoV2MapByUserToken(DWServiceContext.getContext().getRequestHeader().get(MdcConstant.TOKEN).toString());

        ArrayNode companySiteIdMappings = mapper.createArrayNode();


        Map<String,String> omIdMap = new HashMap<>();

        //先确认集团数据，方便查询om逻辑
        for (EocIntgMapping eocIntgMapping : tEocIntgMappings) {
            if (eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.enterprise_id.toString())) {
                tEnterpriseIdMappings.add(eocIntgMapping);
            }
        }

        // 取得穩態產品om
        JsonNode tOmInfoNode;
        //畫面上沒有傳集團碼
        if (StringUtil.isEmpty(pEnterPriseId)) {
            //如果數據庫中有集團的配置就用數據庫的
            if (!tEnterpriseIdMappings.isEmpty()) {
                tOmInfoNode = IntgInfoServiceUtil.getIntgInfo(tEnterpriseIdMappings.get(0).getEocId(), pTenantId, pProdName, pUid);
            } else {
                tOmInfoNode = IntgInfoServiceUtil.getIntgInfo(null, pTenantId, pProdName, pUid);
            }
            //畫面上有傳集團碼
        } else {
            tOmInfoNode = IntgInfoServiceUtil.getIntgInfo(pEnterPriseId, pTenantId, pProdName, pUid);
        }

        ArrayNode tIntgCompanyAryNode = (ArrayNode) tOmInfoNode.get(MdcConstant.ORG_TYPE_COMPANY);

        Map<String,String> omIdNameMap = new HashMap<>();

        tIntgCompanyAryNode.forEach(x->{
            omIdNameMap.put(x.get(MdcConstant.COMPANY_NO).asText(), x.get(MdcConstant.COMPANY_NAME).asText());
            if (x.get(MdcConstant.ORG_TYPE_SITE) != null) {
                ArrayNode tOrgTypeSiteAryNodeUnderCompany = (ArrayNode) x.get(MdcConstant.ORG_TYPE_SITE);
                tOrgTypeSiteAryNodeUnderCompany.forEach(y-> omIdNameMap.put(y.get(MdcConstant.SITE_NO).asText(),y.get(MdcConstant.SITE_NAME).asText()));
            }
        });

        // 將tEocIntgMappings依據eoc_level分出來
        for (EocIntgMapping eocIntgMapping : tEocIntgMappings) {

            omIdMap.put(eocIntgMapping.getIntgId(),eocIntgMapping.getIntgId());
            if (eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.company_id.toString())) {
                ObjectNode tCompanyLevelMappingNode = mapper.createObjectNode();
                tCompanyLevelMappingNode.put(MdcConstant.EOC_MAPPING_ID, eocIntgMapping.getEocId());
                tCompanyLevelMappingNode.put(MdcConstant.OM_MAPPING_ID, eocIntgMapping.getIntgId());

                if (eocIdMapping.get(eocIntgMapping.getEocId()) !=  null) {
                    tCompanyLevelMappingNode.put(MdcConstant.EOC_MAPPING_NAME, eocIdMapping.get(eocIntgMapping.getEocId()));
                }

                if(omIdNameMap.get(eocIntgMapping.getIntgId()) != null){
                    tCompanyLevelMappingNode.put(MdcConstant.OM_MAPPING_NAME, omIdNameMap.get(eocIntgMapping.getIntgId()));
                }
                if (eocIntgMapping.getDatakey() != null && !eocIntgMapping.getDatakey().isEmpty()) {
                    tCompanyLevelMappingNode.put(MdcConstant.DATAKEY, eocIntgMapping.getDatakey());
                }
                companySiteIdMappings.add(tCompanyLevelMappingNode);
                // 加上"enable":true字段(表示此配置已啟用)
                tCompanyLevelMappingNode.put(MdcConstant.ENABLE, true);
                tCompanyLevelMappingNode.put(MdcConstant.MAPPING_TYPE, MdcConstant.COMPANY_ID);
            } else if (eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.site_id.toString())) {
                ObjectNode tSiteLevelMappingNode = mapper.createObjectNode();
                tSiteLevelMappingNode.put(MdcConstant.EOC_MAPPING_ID, eocIntgMapping.getEocId());
                tSiteLevelMappingNode.put(MdcConstant.OM_MAPPING_ID, eocIntgMapping.getIntgId());

                if (eocIdMapping.get(eocIntgMapping.getEocId()) !=  null) {
                    tSiteLevelMappingNode.put(MdcConstant.EOC_MAPPING_NAME, eocIdMapping.get(eocIntgMapping.getEocId()));
                }

                if(omIdNameMap.get(eocIntgMapping.getIntgId()) != null){
                    tSiteLevelMappingNode.put(MdcConstant.OM_MAPPING_NAME, omIdNameMap.get(eocIntgMapping.getIntgId()));
                }
                if (eocIntgMapping.getDatakey() != null && !eocIntgMapping.getDatakey().isEmpty()) {
                    tSiteLevelMappingNode.put(MdcConstant.DATAKEY, eocIntgMapping.getDatakey());
                }
                // 加上"enable":true字段(表示此配置已啟用)
                tSiteLevelMappingNode.put(MdcConstant.ENABLE, true);
                tSiteLevelMappingNode.put(MdcConstant.MAPPING_TYPE, MdcConstant.SITE_ID);

                companySiteIdMappings.add(tSiteLevelMappingNode);
            } else if (eocIntgMapping.getCloudMappingType().equals(EocLevelEnum.region_id.toString())) {
                tRegionIdMappings.add(eocIntgMapping);
            }
        }
        // 組成回傳json
        // 組成org_type_enterprise物件
        ObjectNode tEnterpriseLevelMappingNode = mapper.createObjectNode();
        if (!tEnterpriseIdMappings.isEmpty()) {
            EocIntgMapping mapping = tEnterpriseIdMappings.get(0);
            tEnterpriseLevelMappingNode.put(MdcConstant.EOC_ENTERPRISE_ID, mapping.getEocId());
            tEnterpriseLevelMappingNode.put(MdcConstant.OM_ENTERPRISE_ID, mapping.getIntgId());
            if (mapping.getDatakey() != null && !mapping.getDatakey().isEmpty()) {
                tEnterpriseLevelMappingNode.put(MdcConstant.DATAKEY, mapping.getDatakey());
            }
        }

        // 組成org_type_region陣列
        ArrayNode tOrgTypeRegionArrayNode = mapper.createArrayNode();
        for (EocIntgMapping tRegionIdMapping : tRegionIdMappings) {
            ObjectNode tRegionLevelMappingNode = mapper.createObjectNode();
            tRegionLevelMappingNode.put(MdcConstant.EOC_REGION_ID, tRegionIdMapping.getEocId());
            tRegionLevelMappingNode.put(MdcConstant.OM_REGION_ID, tRegionIdMapping.getIntgId());
            /*if (tRegionIdMapping.getRegionType() == null) {
                tRegionLevelMappingNode.put(MdcConstant.REGION_TYPE, "");
            } else {
                tRegionLevelMappingNode.put(MdcConstant.REGION_TYPE, tRegionIdMapping.getRegionType());
            }*/
            if (tRegionIdMapping.getDatakey() != null && !tRegionIdMapping.getDatakey().isEmpty()) {
                tRegionLevelMappingNode.put(MdcConstant.DATAKEY, tRegionIdMapping.getDatakey());
            }
            // 加上"enable":true字段(表示此配置已啟用)
            tRegionLevelMappingNode.put(MdcConstant.ENABLE, true);
            tOrgTypeRegionArrayNode.add(tRegionLevelMappingNode);
        }

        // 從tOmInfoNode裡面的org_type_company[]開始逐個檢查
        for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {

            // 沒有配置過的om_company_id，則將對應放入回傳json，狀態為禁用("enable":false)
            ObjectNode tAddCompanyMappingNode = mapper.createObjectNode();
            if (omIdMap.get(tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText()) == null) {
                tAddCompanyMappingNode.put(MdcConstant.EOC_MAPPING_ID, tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText());
                tAddCompanyMappingNode.put(MdcConstant.OM_MAPPING_ID, tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText());
                tAddCompanyMappingNode.put(MdcConstant.OM_MAPPING_NAME, tIntgCompanyObject.get(MdcConstant.COMPANY_NAME).asText());

                if(eocIdMapping.get(tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText()) != null){
                    tAddCompanyMappingNode.put(MdcConstant.EOC_MAPPING_NAME, eocIdMapping.get(tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText()));
                }
                // 加上"enable":false字段(表示此配置未啟用)
                tAddCompanyMappingNode.put(MdcConstant.ENABLE, false);
                tAddCompanyMappingNode.put(MdcConstant.MAPPING_TYPE, MdcConstant.COMPANY_ID);
                companySiteIdMappings.add(tAddCompanyMappingNode);
            }
            // 檢查該company_no底下的org_type_site陣列內容
            if (tIntgCompanyObject.get(MdcConstant.ORG_TYPE_SITE) != null) {
                ArrayNode tOrgTypeSiteAryNodeUnderCompany = (ArrayNode) tIntgCompanyObject.get(MdcConstant.ORG_TYPE_SITE);

                for (JsonNode  tSiteNode : tOrgTypeSiteAryNodeUnderCompany) {
                    //未配置工厂
                    if(omIdMap.get(tSiteNode.get(MdcConstant.SITE_NO).asText()) == null){
                        ObjectNode tAddSiteMappingNode = mapper.createObjectNode();
                        tAddSiteMappingNode.put(MdcConstant.EOC_MAPPING_ID, tSiteNode.get(MdcConstant.SITE_NO).asText());
                        tAddSiteMappingNode.put(MdcConstant.OM_MAPPING_ID, tSiteNode.get(MdcConstant.SITE_NO).asText());

                        if(eocIdMapping.get(tSiteNode.get(MdcConstant.SITE_NO).asText()) != null){
                            tAddSiteMappingNode.put(MdcConstant.EOC_MAPPING_NAME, eocIdMapping.get(tSiteNode.get(MdcConstant.SITE_NO).asText()));
                        }
                        tAddSiteMappingNode.put(MdcConstant.OM_MAPPING_NAME, tSiteNode.get(MdcConstant.SITE_NAME).asText());
                        // 加上"enable":false字段(表示此配置未啟用)
                        tAddSiteMappingNode.put(MdcConstant.ENABLE, false);
                        tAddSiteMappingNode.put(MdcConstant.MAPPING_TYPE, MdcConstant.SITE_ID);
                        companySiteIdMappings.add(tAddSiteMappingNode);
                    }
                }
            }
        }
        StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription =getDescriptionByLocale(tStateCode, locale);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set(MdcConstant.ORG_TYPE_ENTERPRISE, tEnterpriseLevelMappingNode);
        tResponseJsonNode.set(MdcConstant.ORG_TYPE_MAPPING, companySiteIdMappings);
        tResponseJsonNode.set(MdcConstant.ORG_TYPE_REGION, tOrgTypeRegionArrayNode);
        tResponseJsonNode.put(MdcConstant.TENANT_ID, pTenantId);
        tResponseJsonNode.put(MdcConstant.PROD_NAME, pProdName);
        tResponseJsonNode.put(MdcConstant.UID, pUid);
        return converJsonNodeToMap(tResponseJsonNode);
    }
}
