package com.digiwin.metadatacache.apiservice;

import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.EocInfoServiceUtil;
import com.digiwin.metadatacache.util.IntgInfoServiceUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得自動配對EOC運營單元碼清單
 * Path:[/restful/standard/mdc/DefaultEocMapping/Get]
 */
@org.springframework.stereotype.Service
public class DefaultEocMappingGetService extends AbstractApiService {

	public DefaultEocMappingGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.DEFAULT_EOC_MAPPING_GET_SCHEMA;
	}

	/**
	 * 取得自動配對EOC運營單元碼清單（om中存在的）
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		String tProdName = tRequestJsonNode.get(MdcConstant.PROD_NAME).asText();
		String tUid = tRequestJsonNode.get(MdcConstant.UID).asText();
		// 通过租户转换成token查询eoc运营单元清单
		ObjectNode tEocNode = EocInfoServiceUtil.getEocInfoByTenantId(tTenantId);
		// 根據tProdName, tUid呼叫ESP->ERP取得集成代碼 om信息
		JsonNode tIntgInfoNode = IntgInfoServiceUtil.getIntgInfo(null, tTenantId, tProdName, tUid);
		ArrayNode tMappingInfoAryNode = mapper.createArrayNode();
		ObjectNode tEocDataNode = (ObjectNode) tEocNode.get(MdcConstant.DATA);
		ArrayNode tEocCompanyAryNode = (ArrayNode) tEocDataNode.get(MdcConstant.COMPANIES);
		ArrayNode tEocFactoriesAryNode = (ArrayNode) tEocDataNode.get(MdcConstant.FACTORIES);
		ArrayNode tEocRegionAryNode = (ArrayNode) tEocDataNode.get(MdcConstant.AREAS);
		for (JsonNode tEocCompanyObject : tEocCompanyAryNode) {
			ArrayNode tIntgCompanyAryNode = (ArrayNode) tIntgInfoNode.get(MdcConstant.ORG_TYPE_COMPANY);
			for (JsonNode tIntgCompanyObject : tIntgCompanyAryNode) {
				ObjectNode tAddMappingNode = mapper.createObjectNode();
				// 雲的eoc_info-companies-id有等於地的intg_info-org_type_company-company_no
				if (tEocCompanyObject.get(MdcConstant.ID).asText().equals(tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText())) {
					tAddMappingNode.put(MdcConstant.EOC_ID, tEocCompanyObject.get(MdcConstant.ID).asText());
					tAddMappingNode.put(MdcConstant.INTG_ID, tIntgCompanyObject.get(MdcConstant.COMPANY_NO).asText());
					tAddMappingNode.put(MdcConstant.LEVEL, MdcConstant.COMPANY_ID);
					tAddMappingNode.put(MdcConstant.PROD_NAME, tProdName);
					tAddMappingNode.put(MdcConstant.UID, tUid);
					tMappingInfoAryNode.add(tAddMappingNode);
					for (JsonNode tEocFactoryObject : tEocFactoriesAryNode) {
						// 找出所有此雲EOC的子集
						if (tEocFactoryObject.get(MdcConstant.COMPANYID).asText().equals(tEocCompanyObject.get(MdcConstant.ID).asText())) {
							ObjectNode tAddMappingWithParentNode = mapper.createObjectNode();
							if (tIntgCompanyObject.get(MdcConstant.ORG_TYPE_SITE) != null) {
								ArrayNode tIntgSiteAryNodeUnderCompany = (ArrayNode) tIntgCompanyObject
										.get(MdcConstant.ORG_TYPE_SITE);
								for (JsonNode tIntgSiteObject : tIntgSiteAryNodeUnderCompany) {
									if (tIntgSiteObject.get(MdcConstant.SITE_NO).asText()
											.equals(tEocFactoryObject.get(MdcConstant.ID).asText())) {
										tAddMappingWithParentNode.put(MdcConstant.EOC_ID, tEocFactoryObject.get(MdcConstant.ID).asText());
										tAddMappingWithParentNode.put(MdcConstant.INTG_ID, tIntgSiteObject.get(MdcConstant.SITE_NO).asText());
										tAddMappingWithParentNode.put(MdcConstant.LEVEL, MdcConstant.SITE_ID);
										tAddMappingWithParentNode.put(MdcConstant.PARENT_LEVEL, MdcConstant.COMPANY_ID);
										tAddMappingWithParentNode.put(MdcConstant.PARENT_EOC_ID,
												tEocCompanyObject.get(MdcConstant.ID).asText());
										tAddMappingWithParentNode.put(MdcConstant.PROD_NAME, tProdName);
										tAddMappingWithParentNode.put(MdcConstant.UID, tUid);
										tMappingInfoAryNode.add(tAddMappingWithParentNode);
									}
								}
							}
						}
					}
				}
			}
		}
		for (JsonNode tEocRegionObject : tEocRegionAryNode) {
			ArrayNode tIntgRegionAryNode = (ArrayNode) tIntgInfoNode.get(MdcConstant.ORG_TYPE_REGION);
			for (JsonNode tIntgRegionObject : tIntgRegionAryNode) {
				ObjectNode tAddMappingNode = mapper.createObjectNode();
				// 雲EOC有對到ESP代碼 (Region層級)
				if (tEocRegionObject.get(MdcConstant.ID).asText().equals(tIntgRegionObject.get(MdcConstant.REGION_NO).asText())
						&& tIntgRegionObject.get(MdcConstant.REGION_TYPE).asText().equals(tEocRegionObject.get(MdcConstant.TYPE).asText())) {
					tAddMappingNode.put(MdcConstant.EOC_ID, tEocRegionObject.get(MdcConstant.ID).asText());
					tAddMappingNode.put(MdcConstant.REGION_TYPE, tIntgRegionObject.get(MdcConstant.REGION_TYPE).asText());
					tAddMappingNode.put(MdcConstant.INTG_ID, tIntgRegionObject.get(MdcConstant.REGION_NO).asText());
					tAddMappingNode.put(MdcConstant.LEVEL, MdcConstant.REGION_ID);
					tAddMappingNode.put(MdcConstant.PROD_NAME, tProdName);
					tAddMappingNode.put(MdcConstant.UID, tUid);
					tMappingInfoAryNode.add(tAddMappingNode);
				}
			}
		}
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		tResponseJsonNode.set(MdcConstant.MAPPING_INFO, tMappingInfoAryNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}