package com.digiwin.metadatacache.apiservice;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.springframework.beans.factory.annotation.Autowired;

import com.digiwin.metadatacache.dao.EaiTenantMappingDao;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.dao.ProductDao;
import com.digiwin.metadatacache.dao.ServiceDao;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EaiTenantMapping;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;
import com.digiwin.metadatacache.model.Product;
import com.digiwin.metadatacache.model.Service;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 更新運營配置（同步eoc與om代碼對應）
 * Path:[/restful/standard/mdc/EOCIntgMap/Update]
 */
@org.springframework.stereotype.Service
public class EOCIntgMapUpdateService extends AbstractApiService {

	@Autowired
	private ProductDao productDao;

	@Autowired
	private ServiceDao serviceDao;

	@Autowired
	private EocIntgMappingDao eocIntgMappingDao;

	@Autowired
	private PrdDatakeyMappingDao prdDatakeyMappingDao;

	@Autowired
	private EaiTenantMappingDao eaiTenantMappingDao;

	public EOCIntgMapUpdateService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.EOC_INTG_MAP_UPDATE_SCHEMA;
	}

	/**
	 * 更新eoc_intg_mapping大表(新增、修改、刪除)
	 * 删除-需要清除产品对应的
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		updateEocOmMapping(tRequestJsonNode);
		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription =getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		return converJsonNodeToMap(tResponseJsonNode);
	}

	private void updateEocOmMapping(JsonNode pNode) {
		List<EocIntgMapping> tList = new ArrayList<>();
		ArrayNode tMappingInfoAryNode = (ArrayNode) pNode.get(MdcConstant.MAPPING_INFO);
		String tTenantId = pNode.get(MdcConstant.TENANT_ID).asText();
		String tAction = pNode.get(MdcConstant.ACTION).asText();
		String tEocSetting = null;
		String tEocSettingRegion = null;
		// 有給eoc_setting且有值
		if (pNode.get(MdcConstant.EOC_SETTING) != null && pNode.get(MdcConstant.EOC_SETTING).asText().length() != 0) {
			tEocSetting = pNode.get(MdcConstant.EOC_SETTING).asText();
		}
		// 有給eoc_setting_region且有值
		if (pNode.get(MdcConstant.EOC_SETTING_REGION) != null && pNode.get(MdcConstant.EOC_SETTING_REGION).asText().length() != 0) {
			tEocSettingRegion = pNode.get(MdcConstant.EOC_SETTING_REGION).asText();
		}
		// 刪除某租戶ID、UID相關的eoc_intg_mapping
		if (tAction.equals(MdcConstant.DELETE)) {
			String tLevel = pNode.get(MdcConstant.LEVEL).asText();
			// 取得入參UID
			String tUid = pNode.get(MdcConstant.UID).asText();
			// 將該租戶ID、UID相關的eoc_intg_mapping都刪除
			eocIntgMappingDao.clearListWithLevel(tTenantId, tUid, tLevel);
			// 取得該UID的產品主機(product資料表)
			Map<String, String> tProductCondition = new HashMap<>();
			tProductCondition.put(MdcConstant.TENANT, tTenantId);
			tProductCondition.put(MdcConstant.UID, tUid);
			List<Product> tProducts = productDao.fetch(tProductCondition);
			// 取得該租戶該產品主機的運營資料
			Map<String, String> tEocIntgCondition = new HashMap<>();
			tEocIntgCondition.put(MdcConstant.PRODUCT_UID, tUid);
			tEocIntgCondition.put(MdcConstant.TENANT_ID, tTenantId);
			List<EocIntgMapping> tEocIntgMappings = eocIntgMappingDao.fetch(tEocIntgCondition);
			// 舊規則：將該產品主機的tenant_id設為空字串
			// 新規則：如果該租戶已經沒有該產品主機的運營資料，則將該產品主機的tenant_id設為空字串
			if (tProducts != null && tProducts.size() != 0 && tEocIntgMappings.size() == 0) {
				tProducts.get(0).setTenantId("");
				productDao.save(tProducts.get(0));
			}
		} else {
			// 新增或更新eoc_intg_mapping
			if (tMappingInfoAryNode.isArray()) {
				for (JsonNode tNode : tMappingInfoAryNode) {
					// 先把沒有階層關係的存起來
					if ((tNode.get(MdcConstant.PARENT_EOC_ID) == null || tNode.get(MdcConstant.PARENT_EOC_ID).asText().length() == 0)) {
						EocIntgMapping tMapping = new EocIntgMapping();
						// 沒有eoc_id element則不新增該筆運營
						if (tNode.get(MdcConstant.EOC_ID) == null) {
							continue;
						} else {
							tMapping.setEocId(tNode.get(MdcConstant.EOC_ID).asText());
						}
						tMapping.setIntgId(tNode.get(MdcConstant.INTG_ID).asText());
						tMapping.setEocLevel(tNode.get(MdcConstant.LEVEL).asText());
						tMapping.setProducName(tNode.get(MdcConstant.PROD_NAME).asText());
						tMapping.setProductUid(tNode.get(MdcConstant.UID).asText());
						tMapping.setTenantId(tTenantId);
						if (tNode.get(MdcConstant.REGION_TYPE) != null) {
							tMapping.setRegionType(tNode.get(MdcConstant.REGION_TYPE).asText());
						}
						Map<String, String> tPrdDatakeyMappingCondition = new HashMap<>();
						tPrdDatakeyMappingCondition.put(MdcConstant.PROD_NAME, tNode.get(MdcConstant.PROD_NAME).asText());
						tPrdDatakeyMappingCondition.put(MdcConstant.EOC_LEVEL, tNode.get(MdcConstant.LEVEL).asText());
						List<PrdDatakeyMapping> tDatakeyMappings = prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
						if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
							tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
						}
						tMapping.setBuildTime(Calendar.getInstance());
						tList.add(tMapping);
					}
				}
			}
			// 更新則先把該租戶ID、UID的eoc_intg_mapping
			if (pNode.get(MdcConstant.EOC_SETTING_REGION) != null) {
				eocIntgMappingDao.clearListWithLevel(tTenantId, tList.get(0).getProductUid(), "Region");
			} else {
				eocIntgMappingDao.clearList(tTenantId, tList.get(0).getProductUid());
			}
			// 先處理沒有階層關係的eoc_intg_mapping資料
			eocIntgMappingDao.updateList(tList);
			tList.clear();
			// 建立階層關係
			for (JsonNode tNode : tMappingInfoAryNode) {
				if (tNode.get(MdcConstant.PARENT_EOC_ID) != null && tNode.get(MdcConstant.PARENT_EOC_ID).asText().length() != 0
						&& tNode.get(MdcConstant.PARENT_LEVEL) != null && tNode.get(MdcConstant.PARENT_LEVEL).asText().length() != 0) {
					Map<String, String> tEocIntgMappingCondition = new HashMap<>();
					tEocIntgMappingCondition.put(MdcConstant.EOC_ID, tNode.get(MdcConstant.PARENT_EOC_ID).asText());
					tEocIntgMappingCondition.put(MdcConstant.EOC_LEVEL, tNode.get(MdcConstant.PARENT_LEVEL).asText());
					tEocIntgMappingCondition.put(MdcConstant.PROD_NAME, tNode.get(MdcConstant.PROD_NAME).asText());
					tEocIntgMappingCondition.put(MdcConstant.TENANT_ID, tTenantId);
					List<EocIntgMapping> tEocIntgMappings = eocIntgMappingDao.fetch(tEocIntgMappingCondition);
					EocIntgMapping tMapping = new EocIntgMapping();
					tMapping.setEocId(tNode.get(MdcConstant.EOC_ID).asText());
					tMapping.setIntgId(tNode.get(MdcConstant.INTG_ID).asText());
					tMapping.setEocLevel(tNode.get(MdcConstant.LEVEL).asText());
					tMapping.setProducName(tNode.get(MdcConstant.PROD_NAME).asText());
					tMapping.setProductUid(tNode.get(MdcConstant.UID).asText());
					tMapping.setTenantId(tTenantId);
					if (tEocIntgMappings != null && !tEocIntgMappings.isEmpty()) {
						tMapping.setEocIntgMapping(tEocIntgMappings.get(0));
					}
					Map<String, String> tPrdDatakeyMappingCondition = new HashMap<>();
					tPrdDatakeyMappingCondition.put(MdcConstant.PROD_NAME, tNode.get(MdcConstant.PROD_NAME).asText());
					tPrdDatakeyMappingCondition.put(MdcConstant.EOC_LEVEL, tNode.get(MdcConstant.LEVEL).asText());
					List<PrdDatakeyMapping> tDatakeyMappings = prdDatakeyMappingDao.fetch(tPrdDatakeyMappingCondition);
					if (tDatakeyMappings != null && !tDatakeyMappings.isEmpty()) {
						tMapping.setDatakey(tDatakeyMappings.get(0).getFieldName());
					}
					tMapping.setBuildTime(Calendar.getInstance());
					tList.add(tMapping);
				}
			}
			// 再處理有階層關係的eoc_intg_mapping資料
			eocIntgMappingDao.updateList(tList);
			// 用UID找出所有符合的產品
			Map<String, String> tProductCondition = new HashMap<>();
			tProductCondition.put(MdcConstant.UID, tMappingInfoAryNode.get(0).get(MdcConstant.UID).asText());
			List<Product> tProducts = productDao.fetch(tProductCondition);
			boolean tProductWithSameTenantIdExist = false;
			boolean tProductWithNoTenantIdExist = false;
			for (Product tProduct : tProducts) {
				// 存在相同租戶ID的產品
				if (tTenantId.equals(tProduct.getTenantId())) {
					if (tEocSetting != null) {
						tProduct.setEocSetting(tEocSetting);
					}
					if (tEocSettingRegion != null) {
						tProduct.setEocSettingRegion(tEocSettingRegion);
					}
					tProduct.setLastUpdateTime(Calendar.getInstance());
					productDao.save(tProduct);
					tProductWithSameTenantIdExist = true;
				}
			}
			// 不存在相同租戶ID的產品
			if (!tProductWithSameTenantIdExist) {
				// 複製其中一筆產品的資訊和服務清單
				for (Product tProduct : tProducts) {
					if (tProduct.getTenantId() == null || tProduct.getTenantId().length() == 0) {
						Map<String, String> tCondition = new HashMap<>();
						tCondition.put(MdcConstant.TENANT, tTenantId);
						List<EaiTenantMapping> eaiTenantMappings = eaiTenantMappingDao.fetch(tCondition);
						// 要檢查是否相同eai uid
						if (eaiTenantMappings != null && eaiTenantMappings.size() != 0
								&& tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) {
							// 存在無租戶ID的產品，則設定租戶ID、儲存
							if (tEocSetting != null) {
								tProduct.setEocSetting(tEocSetting);
							}
							if (tEocSettingRegion != null) {
								tProduct.setEocSettingRegion(tEocSettingRegion);
							}
							tProduct.setTenantId(tTenantId);
							tProduct.setLastUpdateTime(Calendar.getInstance());
							productDao.save(tProduct);
							tProductWithNoTenantIdExist = true;
							break;
						}
					}
				}
				// 不存在無租戶ID的產品
				if (!tProductWithNoTenantIdExist) {
					for (Product tProduct : tProducts) {
						Map<String, String> tCondition = new HashMap<>();
						tCondition.put(MdcConstant.TENANT, tTenantId);
						List<EaiTenantMapping> eaiTenantMappings = eaiTenantMappingDao.fetch(tCondition);
						if (eaiTenantMappings != null && eaiTenantMappings.size() != 0
								&& tProduct.getEaiUid().equals(eaiTenantMappings.get(0).getEaUid())) {
							List<Service> tServices = serviceDao.getByPrdId(tProduct.getId());
							// 設定租戶ID、清空主鍵、儲存
							if (tEocSetting != null) {
								tProduct.setEocSetting(tEocSetting);
							}
							if (tEocSettingRegion != null) {
								tProduct.setEocSettingRegion(tEocSettingRegion);
							}
							tProduct.setBuildTime(Calendar.getInstance());
							tProduct.setTenantId(tTenantId);
							tProduct.setId(null);
							Product tReturnedProduct = productDao.save(tProduct);
							// 設定服務清單
							for (Service service : tServices) {
								service.setProduct(tReturnedProduct);
								service.setId(null);
								serviceDao.save(service);
							}
							break;
						}
					}
				}
			}
		}
	}
}