package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.util.IamVerifyServiceUtil;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

import java.util.Map;

/**
 * 取得租戶version信息
 * Path:[/restful/standard/mdc/TenantInfo/Get]
 */
@org.springframework.stereotype.Service
public class TenantInfoGetService extends AbstractApiService {

	public TenantInfoGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.TENANT_INFO_GET_SCHEMA;
	}

	/**
	 * 取得租戶version信息
	 * @param validatorResult      * @param validatorResult
	 * @return Map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
				+ ", 原始訊息: " + tRequestJsonNode);
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();

		//String token = IamVerifyServiceUtil.getTenantToken(tTenantId);
		String version = IamVerifyServiceUtil.getCurrentTenantVersion(tTenantId);

		StateCode tStateCode = getStateCode(validatorResult.getState().getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);

		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
		tResponseJsonNode.put(MdcConstant.VERSION, version);
		//tResponseJsonNode.put(MdcConstant.TOKEN, token);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}