package com.digiwin.metadatacache.apiservice;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import org.springframework.beans.factory.annotation.Autowired;

import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

/**
 * 取得運營單元轉換資訊<br>
 * Path:[/restful/standard/mdc/TenantOrganizationTrans/Get]
 */
@org.springframework.stereotype.Service
public class TenantOrganizationTransGetService extends AbstractApiService {

	@Autowired
	private EocIntgMappingDao eocIntgMappingDao;

	public TenantOrganizationTransGetService() {
		super();
		jsonSchemaFileName = JsonSchemaFileConstant.TENANT_ORG_TRANS_GET_SCHEMA;
	}

	/**
	 * 取得運營單元轉換資訊
	 * @param validatorResult      * @param validatorResult
	 * @return map
	 * @throws BaseException BaseException
	 * @throws Exception Exception
	 */
	@Override
	protected Map<String, Object> processData(ValidatorResult validatorResult) throws BaseException, Exception {
		JsonNode tRequestJsonNode = validatorResult.getJsonContent();
		// 取得入參tenant_id, prod_name, target, source(array)
		String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
		String tProdName = tRequestJsonNode.get(MdcConstant.PROD_NAME).asText();
		String tTarget = tRequestJsonNode.get(MdcConstant.TARGET).asText();
		ArrayNode tSourceAryNode = (ArrayNode) tRequestJsonNode.get(MdcConstant.SOURCE);
		// 取得符合入參tenant_id, prod_name的eoc_intg_mappings並轉成map型式
		Map<String, String> pEocIntgMapCondition = new HashMap<>();
		pEocIntgMapCondition.put(MdcConstant.TENANT_ID, tTenantId);
		pEocIntgMapCondition.put(MdcConstant.PROD_NAME, tProdName);
		List<EocIntgMapping> eocIntgMappings = eocIntgMappingDao.fetch(pEocIntgMapCondition);
		Map<String, Map<String, Map<String, List<EocIntgMapping>>>> tEocIntgMappingsMap
				= groupEocMappingByTenantAndProdNameAndUid(eocIntgMappings, tTenantId);
		// 組成回傳的json訊息
		ObjectNode tDataNode = mapper.createObjectNode();
		ArrayNode tResultAryNode = mapper.createArrayNode();
		tDataNode.set(MdcConstant.RESULT, tResultAryNode);
		tDataNode.put(MdcConstant.TENANT_ID, tTenantId);
		// 轉換成運營單元碼
		if (tTarget.equals(MdcConstant.EOC)) {
			for (JsonNode tJsonNode : tSourceAryNode) {
				ObjectNode tObject = mapper.createObjectNode();
				if (tEocIntgMappingsMap != null && tEocIntgMappingsMap.get(tTenantId) != null
						&& tEocIntgMappingsMap.get(tTenantId).get(tProdName) != null) {
					// 取得每一個source array item
					// 從eoc_intg_mapping資料中取得符合EOC_level以及代碼的mapping
					for (String key : tEocIntgMappingsMap.get(tTenantId).get(tProdName).keySet()) {
						for (EocIntgMapping mapping : tEocIntgMappingsMap.get(tTenantId).get(tProdName).get(key)) {
							tObject.put(MdcConstant.LEVEL, tJsonNode.get(MdcConstant.LEVEL).asText());
							tObject.put(MdcConstant.ID, tJsonNode.get(MdcConstant.ID).asText());
							if (mapping.getEocLevel().equals(tJsonNode.get(MdcConstant.LEVEL).asText())
									&& mapping.getIntgId().equals(tJsonNode.get(MdcConstant.ID).asText())) {
								tObject.put(MdcConstant.VALUE, mapping.getEocId());
								break;
							}
							tObject.set(MdcConstant.VALUE, NullNode.getInstance());
						}
						tResultAryNode.add(tObject);
					}
				} else {
					tObject.put(MdcConstant.LEVEL, tJsonNode.get(MdcConstant.LEVEL).asText());
					tObject.put(MdcConstant.ID, tJsonNode.get(MdcConstant.ID).asText());
					tObject.set(MdcConstant.VALUE, NullNode.getInstance());
					tResultAryNode.add(tObject);
				}
			}
		} else if (tTarget.equals(MdcConstant.PROD)) {
			// 轉換成集成代碼
			for (JsonNode tJsonNode : tSourceAryNode) {
				ObjectNode tObject = mapper.createObjectNode();
				if (tEocIntgMappingsMap != null && tEocIntgMappingsMap.get(tTenantId) != null
						&& tEocIntgMappingsMap.get(tTenantId).get(tProdName) != null) {
					// 取得每一個source array item
					// 從eoc_intg_mapping資料中取得符合EOC_level以及代碼的mapping
					for (String key : tEocIntgMappingsMap.get(tTenantId).get(tProdName).keySet()) {
						for (EocIntgMapping mapping : tEocIntgMappingsMap.get(tTenantId).get(tProdName).get(key)) {
							tObject.put(MdcConstant.LEVEL, tJsonNode.get(MdcConstant.LEVEL).asText());
							tObject.put(MdcConstant.ID, tJsonNode.get(MdcConstant.ID).asText());
							if (mapping.getEocLevel().equals(tJsonNode.get(MdcConstant.LEVEL).asText()) && mapping.getEocId().equals(tJsonNode.get(MdcConstant.ID).asText())) {
								tObject.put(MdcConstant.VALUE, mapping.getIntgId());
								break;
							}
							tObject.set(MdcConstant.VALUE, NullNode.getInstance());
						}
						tResultAryNode.add(tObject);
					}
				} else {
					tObject.put(MdcConstant.LEVEL, tJsonNode.get(MdcConstant.LEVEL).asText());
					tObject.put(MdcConstant.ID, tJsonNode.get(MdcConstant.ID).asText());
					tObject.set(MdcConstant.VALUE, NullNode.getInstance());
					tResultAryNode.add(tObject);
				}
			}
		}
		StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
		String tDescription = getDescriptionByLocale(tStateCode, locale);
		ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, tDataNode);
		return converJsonNodeToMap(tResponseJsonNode);
	}
}
