package com.digiwin.metadatacache.apiservice;

import com.digiwin.metadatacache.constant.JsonSchemaFileConstant;
import com.digiwin.metadatacache.constant.MdcConstant;
import com.digiwin.metadatacache.dao.EocIntgMappingDao;
import com.digiwin.metadatacache.enums.ValidateStateEnum;
import com.digiwin.metadatacache.exception.BaseException;
import com.digiwin.metadatacache.model.EocIntgMapping;
import com.digiwin.metadatacache.model.StateCode;
import com.digiwin.metadatacache.validator.ValidatorResult;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author clay
 * on 2025/3/21
 */

/**
 * 取得雲地映射配置
 * Path:[/restful/standard/mdc/TenantProductCloudMapping/Get]
 */
@Service
public class TenantProductCloudMappingGetService extends AbstractApiService {

    @Autowired
    private EocIntgMappingDao eocIntgMappingDao;

    public TenantProductCloudMappingGetService () {
        super();
        jsonSchemaFileName = JsonSchemaFileConstant.TENANT_PRD_CLOUD_MAPPING_GET_SCAHEMA;
    }

    @Override
    protected Map<String, Object> processData (ValidatorResult validatorResult) throws BaseException, Exception {
        JsonNode tRequestJsonNode = validatorResult.getJsonContent();
        log.info("[Thread.id " + Thread.currentThread().getId() + "]" + "接口: " + this.getClass()
                         + ", 原始訊息: " + tRequestJsonNode);
        // 取出入參tenant
        String tTenantId = tRequestJsonNode.get(MdcConstant.TENANT_ID).asText();
        Boolean tNameInclude = tRequestJsonNode.get(MdcConstant.NAME_INCLUDE).asBoolean();


        return processTenantCloudMappingGet(tTenantId, tNameInclude);
    }

    private Map<String, Object> processTenantCloudMappingGet (String pTenantId, Boolean pNameInclude) {
        Map<String, String> pCondition = new HashMap<>();
        pCondition.put(MdcConstant.TENANT_ID, pTenantId);
        pCondition.put(MdcConstant.EOC_LEVEL, MdcConstant.CLOUD_MAPPING_ID);
        List<EocIntgMapping> tMappings = eocIntgMappingDao.fetch(pCondition);

        ObjectNode tEocNode = null;
        // NameInclude=true，代表回傳訊息中要包含運營單元的描述(name)，須向EOC取得
        // 若該租戶還未配置運營，則不用取得token呼叫EOC
//        if (pNameInclude && tMappings.size() != 0) {
//            try {
//                // 根據租戶ID取得EOC運營單元碼
//                tEocNode = EocInfoServiceUtil.getEocInfoByTenantId(pTenantId);
//                // 取得eoc清單時發生任何錯誤都繼續執行，因為取得name值(敘述)是額外的資訊
//                // 不要因為取得name值(敘述)失敗，而影響取得運營大表
//            } catch (Exception e) {
//                log.error(e.getMessage(), e);
//            }
//        }

        // 將tMappings依照產品UID分出來
        Map<String, List<EocIntgMapping>> tMappingsGroupByProductUid = tMappings.stream().collect(Collectors.groupingBy(EocIntgMapping::getProductUid));

        ArrayNode prodCloudMappings = mapper.createArrayNode();
        tMappingsGroupByProductUid.forEach((uid, eocIntgMappings) -> {
            String productName = eocIntgMappings.get(0).getProductName();
            String productUid = uid;

//            JsonNode tIntgInfoNode = null;
//            // 如果有註明需要"敘述" "name_include": true 則根據產品UID取得ESP單元對應碼
//            try {
//                if (pNameInclude) {
//                    /* 取得ESP單元對應碼 */
//                    // 根據tProdName, tUid呼叫ESP->ERP取得集成代碼
//                    tIntgInfoNode = IntgInfoServiceUtil.getIntgInfo(null, pTenantId, productName, productUid);
//                }
//                // 取得地端om時發生任何錯誤也略過 因為取得name_include是額外的功能
//                // 不要因為取得name_include失敗而影響取得運營大表
//            } catch (Exception e) {
//                log.error(e.getMessage(), e);
//            }
            ObjectNode prodCloudMapping = mapper.createObjectNode();
            prodCloudMapping.put(MdcConstant.PROD_NAME, productName);
            prodCloudMapping.put(MdcConstant.UID, productUid);

            ArrayNode mappings = mapper.createArrayNode();
            eocIntgMappings.forEach(eocIntgMapping -> {
                ObjectNode mapping = mapper.createObjectNode();
                mapping.put(MdcConstant.EOC_MAPPING_ID, eocIntgMapping.getEocId());
                mapping.put(MdcConstant.OM_MAPPING_ID, eocIntgMapping.getIntgId());
                mapping.put(MdcConstant.MAPPING_TYPE, eocIntgMapping.getCloudMappingType());
                mappings.add(mapping);
            });
            prodCloudMapping.set(MdcConstant.ORG_TYPE_MAPPING, mappings);
            prodCloudMappings.add(prodCloudMapping);
        });

        StateCode tStateCode = getStateCode(ValidateStateEnum.SUCCESS.getCode());
        String tDescription = getDescriptionByLocale(tStateCode, locale);
        ObjectNode tResponseJsonNode = createResponseJsonNode(tStateCode.getCode(), tDescription, null);
        tResponseJsonNode.set("prod_cloud_mapping", prodCloudMappings);
        tResponseJsonNode.put(MdcConstant.TENANT_ID, pTenantId);
        return converJsonNodeToMap(tResponseJsonNode);
    }
}
