package com.digiwin.metadatacache.apiservice.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: liunansheng
 * @date: 2024/6/24 14:54
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
public class TenantApiProductListGetResponse {

    private String tenantId;

    /**
     * 以apiName作为key
     */
    private Map<String, List<ProductVO>> serviceProductMap;

    @Getter
    @Setter
    public static class ProductVO {

        private String gatewayId;

        private String name;

        private String version;

        private String ip;

        private String id;

        private String uid;

    }

    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>();
        map.put("tenantId", tenantId);
        map.put("serviceProductMap", serviceProductMap);
        return map;
    }
}
