package com.digiwin.metadatacache.config;

import com.alibaba.druid.pool.DruidDataSource;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.orm.jpa.EntityManagerFactoryBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import java.util.Properties;


//@EnableTransactionManagement
//@EnableJpaRepositories
@Configuration
public class MdcHibernateConfig {


    @Value("${hibernate.cache.use_second_level_cache:false}")
    private String use_second_level_cache;

    @Value("${hibernate.cache.use_query_cache:false}")
    private String use_query_cache;


    @Bean("mdcDataSource")
    @ConfigurationProperties(prefix = "mdc.spring.datasource")
    public DruidDataSource mdcDataSource() {
        DruidDataSource druidDataSource= new DruidDataSource();
        return druidDataSource;
    }

    @Bean("mdcLocalSessionFactoryBean")
    public LocalSessionFactoryBean mdcLocalSessionFactoryBean(@Qualifier("mdcDataSource") DataSource dataSource){
        LocalSessionFactoryBean factoryBean = new LocalSessionFactoryBean();
        factoryBean.setDataSource(dataSource);
        factoryBean.setHibernateProperties(hibernateProperties());
        factoryBean.setPackagesToScan("com.digiwin.metadatacache.model");


        return factoryBean;
    }

    @Bean("mdcTransactionManager")
    public HibernateTransactionManager mdcHibernateTransactionManager(@Qualifier("mdcLocalSessionFactoryBean") SessionFactory localSessionFactoryBean){
        HibernateTransactionManager hibernateTransactionManager = new HibernateTransactionManager(localSessionFactoryBean);

        return hibernateTransactionManager;
    }



    private Properties hibernateProperties() {
        Properties properties = new Properties();
        properties.put("hibernate.hbm2ddl.auto", "update");
        properties.put("hibernate.dialect", "org.hibernate.dialect.MySQL8Dialect");
        properties.put("hibernate.show_sql", "true");
        properties.put("hibernate.format_sql","true");
        properties.put("hibernate.query.substitutions","true 'Y', false 'N'");
        properties.put("hibernate.cache.use_second_level_cache",use_second_level_cache);
        properties.put("hibernate.cache.use_query_cache",use_query_cache);
        properties.put("hibernate.cache.region.factory_class","org.hibernate.cache.ehcache.EhCacheRegionFactory");

        return properties;
    }

//    public void test01(){
//        org.springframework.orm.jpa.EntityManagerHolder  entityManagerHolder;
//        org.springframework.orm.hibernate5.SessionHolder sessionHolder;
//    }


}
