package com.digiwin.metadatacache.dao;

import java.util.List;
import java.util.Map;
import com.digiwin.metadatacache.model.Api;

public interface ApiDao extends GenericDao<Api, Long> {

	List<Api> fetch(Map<String, String> pCondition);
	
	Api getByName(String pName);

	Api getByNameAndTenantId(String pName, String pTenantId);
	
	void removeByNameAndVersionTenantId(String pName, String pVersion, String pTenantId);

	List<Api> getUcApi();

	Boolean judgeApi(String pName, String pTenantId, Boolean judge);
}
