package com.digiwin.metadatacache.dao;

import com.digiwin.metadatacache.model.ApiRelation;

import java.util.List;

public interface ApiRelationDao extends GenericDao<ApiRelation, Long> {

    /**
     * 查询关联关系
     * @param apiName api名称
     * @param tenantId 租户Id
     * @return list
     */
    List<ApiRelation> getRelationBySub(String apiName, String tenantId);

    /**
     * 查询关联关系
     * @param apiNames api名称
     * @param tenantId 租户Id
     * @return list
     */
    List<ApiRelation> getRelationBySub(List<String> apiNames, String tenantId);

    /**
     * 查询关联关系
     * @param subApiName 子类名称
     * @param subTenantId 子类租户
     * @return list
     */
    ApiRelation getRelationBySubInfo(String subApiName, String subTenantId);

    /**
     * 查询关联关系
     * @param apiName 子类名称
     * @param tenantId 子类租户
     * @return list
     */
    ApiRelation judgeIsSub(String apiName, String tenantId);

    /**
     * 查询关联关系
     * @param apiName 子类名称
     * @param tenantId 子类租户
     * @return list
     */
    ApiRelation judgeIsParent(String apiName, String tenantId);
}
