package com.digiwin.metadatacache.dao;

import java.util.Calendar;
import java.util.List;

import com.digiwin.metadatacache.model.ApiVersion;

public interface ApiVersionDao extends GenericDao<ApiVersion, Long> {

	List<ApiVersion> getByApiId(Long pId);
	
	ApiVersion getByApiIdAndVer(Long pId, String pVer);
	
	ApiVersion getLatestVerByApiId(long pId);

	List<ApiVersion> getApiInfo(Calendar pStartDate, String pProvider);

	ApiVersion getByApiNameAndVer(String pApiName, String pVer);
	
	ApiVersion getByApiNameTenantVer(String pApiName, String pTenant, String pVer);

	List<ApiVersion> getByApiNameAndTenantId(String apiName, String tenantId);

	List<ApiVersion> getBaseInfoByApiNameAndTenantId(String apiName, String tenantId);
}
