package com.digiwin.metadatacache.dao;

import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.model.EocIntgMapping;

public interface EocIntgMappingDao extends GenericDao<EocIntgMapping, Long> {

    List<EocIntgMapping> fetch(Map<String, String> pCondition);

    /**
     *  针对eocId进行分组去重
     */
    List<EocIntgMapping> fetchGroupByEocId(Map<String, String> pCondition);

    List<EocIntgMapping> updateList(List<EocIntgMapping> pList);

    List<EocIntgMapping> updateCloudList(List<EocIntgMapping> pList);

    void clearList(String pTenantId, String pProductUid);

    void clearListWithLevel(String pTenantId, String pProductUid, String pLevel);

    void deleteMapping(String pTenantId, String pLevel, String pUid, String pProdName, String pEocId, String pOmId);


    /**
     * 删除云映射关系
     */
    void deleteCloudMapping(String pTenantId, String pLevel,String cloudMappingType, String pUid, String pProdName, String pEocId, String pOmId);

    /**
     * 删除云映射关系
     */
    void deleteCloudMapping(String pTenantId, String pProductUid, String pLevel,String cloudMappingType,String productName);

    void deleteChildMapping(long pId);

    List<EocIntgMapping> getChildMapping(long pId);

    void deleteMappingByTenantId(String pTenantId);

}
