package com.digiwin.metadatacache.dao;

import java.util.List;
import java.util.Map;

import com.digiwin.metadatacache.model.Service;

public interface ServiceDao extends GenericDao<Service, Long> {

	public List<Service> fetch(Map<String, String> pCondition);

	public Service getByPrdIdAndServiceName(Long pPrdId, String pServiceName);

	public List<Service> getByPrdId(Long pPrdId);

	public void removeByPrdId(Long pPrdId);

	void saveServices(List<Service> pServices);

	List<Service> getByServiceNames(List<String> serviceNames);

	List<Service> getByPrdAndServiceName(String prod, String prodUid, String pServiceName);

}
