package com.digiwin.metadatacache.dao.impl;

import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.metadatacache.dao.PrdDatakeyMappingDao;
import com.digiwin.metadatacache.model.PrdDatakeyMapping;

@Service
@Transactional("mdcTransactionManager")
public class PrdDatakeyMappingDaoImpl extends GenericDaoImpl<PrdDatakeyMapping, Long> implements PrdDatakeyMappingDao {

	public PrdDatakeyMappingDaoImpl() {
		super(PrdDatakeyMapping.class);
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<PrdDatakeyMapping> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute(new HibernateCallback<List<PrdDatakeyMapping>>() {
			@Override
			public List<PrdDatakeyMapping> doInHibernate(Session pSession) throws HibernateException {
				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = pSession.createCriteria(PrdDatakeyMapping.class);
				tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
				// 設查詢條件
				// containsKey - boolean containsKey(Object key) 判斷map是否包含指定的key
				// MatchMode.ANYWHERE 等同於 like="%name%"
				if (pConditions.containsKey("prod_name")) {
					tCriteria.add(Restrictions.eq("productName", pConditions.get("prod_name")));
				}
				if (pConditions.containsKey("eoc_level")) {
					tCriteria.add(Restrictions.eq("eocLevel", pConditions.get("eoc_level")));
				}
				return tCriteria.list();
			}
		});
	}
}
