package com.digiwin.metadatacache.dao.impl;

import java.util.List;
import java.util.Map;

import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.digiwin.metadatacache.dao.TenantEocSetInfoDao;
import com.digiwin.metadatacache.model.TenantEocSetInfo;

@Service
@Transactional("mdcTransactionManager")
public class TenantEocSetInfoDaoImpl extends GenericDaoImpl<TenantEocSetInfo, Long> implements TenantEocSetInfoDao {

	public TenantEocSetInfoDaoImpl() {
		super(TenantEocSetInfo.class);
	}

	// 查詢資料
	@SuppressWarnings("unchecked")
	@Override
	public List<TenantEocSetInfo> fetch(Map<String, String> pConditions) {
		return getHibernateTemplate().execute(new HibernateCallback<List<TenantEocSetInfo>>() {
			@Override
			public List<TenantEocSetInfo> doInHibernate(Session pSession) throws HibernateException {

				// Hibernate - Criteria Query 標準查詢
				Criteria tCriteria = pSession.createCriteria(TenantEocSetInfo.class);
				tCriteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
				if (pConditions.containsKey("tenant_id")) {
					tCriteria.add(Restrictions.eq("tenantId", pConditions.get("tenant_id")));
				}
				if (pConditions.containsKey("user_id")) {
					tCriteria.add(Restrictions.eq("userId", pConditions.get("user_id")));
				}
				return tCriteria.list();
			}
		});
	}

	/** 刪除子運營 **/
	@Override
	public void deleteIgnoreSetting(String pTenantId) {
		getHibernateTemplate().execute(new HibernateCallback<TenantEocSetInfo>() {
			@Override
			public TenantEocSetInfo doInHibernate(Session pSession) throws HibernateException {
				Query tQ = pSession.createQuery("delete TenantEocSetInfo where tenantId is :tenantId");
				tQ.setParameter("tenantId", pTenantId);
				tQ.executeUpdate();
				return null;
			}
		});
	}
}
